/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.utils.config;

import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import org.json.JSONArray;
import org.json.JSONObject;

public class FFileManager {
    private final String PARENT_DIR;

    public FFileManager(String PARENT_DIR) {
        this.PARENT_DIR = PARENT_DIR;
        this.createFiles();
    }

    void createFiles() {
        for (FILE file : FILE.values()) {
            File f = new File(file.getPath());
            if (f.exists()) continue;
            f.getParentFile().mkdirs();
        }
    }

    private static JSONArray items() {
        JSONArray items = new JSONArray();
        for (int i = 1; i < 4; ++i) {
            JSONObject tier = new JSONObject();
            tier.put("tier" + i, new JSONArray());
            items.put(tier);
        }
        return items;
    }

    public JSONObject save(JSONObject toSaveObject, FILE f) {
        try {
            File file = new File(this.PARENT_DIR + f.path);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                for (DEFAULT_VALUES dv : DEFAULT_VALUES.values()) {
                    if (dv.getF() != f) continue;
                    toSaveObject.put(dv.getKey(), dv.getValue());
                }
            }
            try (FileWriter fileWriter = new FileWriter(file);){
                fileWriter.write(toSaveObject.toString(8));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toSaveObject;
    }

    public JSONObject load(FILE f) {
        JSONObject config = new JSONObject();
        try {
            File file = new File(this.PARENT_DIR + f.path);
            if (!file.exists()) {
                config = this.save(new JSONObject(), f);
            } else {
                String content = new String(Files.readAllBytes(file.toPath()));
                config = new JSONObject(content);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return config;
    }

    public String getPARENT_DIR() {
        return this.PARENT_DIR;
    }

    public static enum FILE {
        CRAFTING("config/crafting.json");

        private final String path;

        private FILE(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }

    private static enum DEFAULT_VALUES {
        noAllowedCraftings("blackList", new JSONArray(), FILE.CRAFTING);

        private final String key;
        private final Object value;
        private final FILE f;

        private DEFAULT_VALUES(String key, Object value, FILE f) {
            this.key = key;
            this.value = value;
            this.f = f;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public FILE getF() {
            return this.f;
        }
    }
}

