/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.mobs.modMobs;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.mobs.modMobs.EntityAttributes;
import me.fixfis.sUHCore.mobs.modMobs.MobAttributes;
import me.fixfis.sUHCore.utils.logger.FLogger;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class CrearMob
implements Listener {
    public static HashMap<String, CrearMob> mobHashMap = new HashMap();
    private final Class<? extends Entity> claseEntidad;
    private final EntityType entityType;
    private final String keyName;
    private double probabilidad;
    private final EntityAttributes entityAttributes;
    private MobAttributes mobAttributes;

    public CrearMob(EntityType entityType, String keyName) {
        this.entityType = entityType;
        this.claseEntidad = entityType.getEntityClass();
        this.keyName = keyName;
        this.probabilidad = 0.0;
        SUHCore.instance.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)SUHCore.instance);
        this.entityAttributes = this.putDefaultAttributes();
        if (this.entityAttributes != null) {
            this.mobAttributes = new MobAttributes(keyName, this.entityAttributes);
            this.probabilidad = this.mobAttributes.getSpawn_prob();
        }
        mobHashMap.put(keyName, this);
        FLogger.info("Mob a\u00f1adido : " + keyName);
    }

    public final Entity summonEntity(Location location) {
        Entity entity = location.getWorld().spawnEntity(location, this.entityType);
        this.initView(entity);
        return entity;
    }

    public final void setAttributes(Mob mob) {
        if (this.entityAttributes == null) {
            return;
        }
        Objects.requireNonNull(mob.getAttribute(Attribute.MAX_HEALTH)).setBaseValue(this.mobAttributes.getHealth());
        Objects.requireNonNull(mob.getAttribute(Attribute.ATTACK_KNOCKBACK)).setBaseValue(this.mobAttributes.getAttack_knockback());
        Objects.requireNonNull(mob.getAttribute(Attribute.KNOCKBACK_RESISTANCE)).setBaseValue(this.mobAttributes.getKnockback_resistance());
        Objects.requireNonNull(mob.getAttribute(Attribute.ARMOR)).setBaseValue(this.mobAttributes.getArmor());
        Objects.requireNonNull(mob.getAttribute(Attribute.SCALE)).setBaseValue(this.mobAttributes.getScale());
        Objects.requireNonNull(mob.getAttribute(Attribute.ATTACK_DAMAGE)).setBaseValue(this.mobAttributes.getAttack_damage());
        Objects.requireNonNull(mob.getAttribute(Attribute.FOLLOW_RANGE)).setBaseValue(this.mobAttributes.getFollow_range());
        Objects.requireNonNull(mob.getAttribute(Attribute.MOVEMENT_SPEED)).setBaseValue(this.mobAttributes.getSpeed());
        Objects.requireNonNull(mob.getAttribute(Attribute.JUMP_STRENGTH)).setBaseValue(this.mobAttributes.getJump());
        if (mob instanceof Creeper) {
            Creeper creeper = (Creeper)mob;
            creeper.setPowered(this.mobAttributes.isPowered());
            creeper.setFuseTicks(this.mobAttributes.getTicks_to_explode());
            creeper.setExplosionRadius(this.mobAttributes.getExplosion_radius().intValue());
        }
    }

    public final boolean isThisEntity(Entity entity) {
        return this.claseEntidad.isInstance(entity) && entity.getScoreboardTags().contains(this.keyName);
    }

    @EventHandler
    public final void onSpawn(EntitySpawnEvent event) {
        if (event.getEntity().getType() == this.entityType) {
            Random random = new Random();
            if ((double)((int)(random.nextDouble() * 100.0)) < this.probabilidad) {
                this.onThisEntitySpawn(event.getEntity(), event);
                this.initView(event.getEntity());
            }
        }
    }

    @EventHandler
    public final void onDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isThisEntity(event.getDamager())) {
                this.onPlayerDamagedByThisEntity(event.getDamager(), player, event);
            } else {
                Entity entity2;
                Arrow arrow;
                Entity entity3 = event.getDamager();
                if (entity3 instanceof Arrow && (entity3 = (arrow = (Arrow)entity3).getShooter()) instanceof Entity && this.isThisEntity(entity2 = entity3)) {
                    this.onPlayerDamagedByThisEntityByArrow(arrow, entity2, player, event);
                }
            }
        } else if (this.isThisEntity(event.getEntity())) {
            Entity entity4 = event.getDamager();
            if (entity4 instanceof Player) {
                Player player = (Player)entity4;
                this.onThisEntityDamagedByPlayer(event.getEntity(), player, event);
            } else {
                Arrow arrow;
                entity4 = event.getDamager();
                if (entity4 instanceof Arrow && (entity4 = (arrow = (Arrow)entity4).getShooter()) instanceof Player) {
                    Player player = (Player)entity4;
                    this.onThisEntityDamagedByPlayerByArrow(arrow, event.getEntity(), player, event);
                }
            }
        }
    }

    @EventHandler
    public final void onEntityDie(EntityDeathEvent event) {
        if (this.isThisEntity((Entity)event.getEntity()) && event.getDamageSource().getDamageType() == DamageType.PLAYER_ATTACK) {
            this.onThisEntityDie((Entity)event.getEntity(), event.getEntity().getKiller(), event);
            this.thisEntityDrops(event.getDrops());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onEntityDamaged(EntityDamageEvent event) {
        if (this.isThisEntity(event.getEntity())) {
            this.onThisEntityDamaged(event.getEntity(), event);
        }
    }

    protected EntityAttributes putDefaultAttributes() {
        return null;
    }

    protected abstract void howThisEntityWouldBe(Mob var1);

    protected void thisEntityDrops(List<ItemStack> drops) {
    }

    protected void onPlayerDamagedByThisEntity(Entity entity, Player player, EntityDamageByEntityEvent event) {
    }

    protected void onThisEntityDamagedByPlayer(Entity entity, Player player, EntityDamageByEntityEvent event) {
    }

    protected void onThisEntityDamaged(Entity entity, EntityDamageEvent event) {
    }

    protected void onPlayerDamagedByThisEntityByArrow(Arrow arrow, Entity entity, Player player, EntityDamageByEntityEvent event) {
    }

    protected void onThisEntityDamagedByPlayerByArrow(Arrow arrow, Entity entity, Player player, EntityDamageByEntityEvent event) {
    }

    protected void onThisEntitySpawn(Entity entity, EntitySpawnEvent event) {
    }

    protected void onThisEntityDie(Entity entity, Player player, EntityDeathEvent event) {
    }

    final void initView(final Entity entity) {
        if (!this.isThisEntity(entity) && entity instanceof Mob) {
            final Mob mob = (Mob)entity;
            new BukkitRunnable(){

                public void run() {
                    entity.addScoreboardTag(CrearMob.this.keyName);
                    CrearMob.this.setAttributes(mob);
                    CrearMob.this.howThisEntityWouldBe(mob);
                }
            }.runTask((Plugin)SUHCore.instance);
        }
    }

    public final void saveData() {
        if (this.entityAttributes != null) {
            this.mobAttributes.save();
        }
    }

    public final void loadData() {
        if (this.entityAttributes != null) {
            this.mobAttributes.load();
            this.probabilidad = this.mobAttributes.getSpawn_prob();
        }
    }

    public final double getProbabilidad() {
        return this.probabilidad;
    }

    public final String getKeyName() {
        return this.keyName;
    }

    public final EntityType getEntityType() {
        return this.entityType;
    }
}

