/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore;

import me.fixfis.InitServer;
import me.fixfis.sUHCore.config.SUHGenericConfig;
import me.fixfis.sUHCore.events.SUHEvents;
import me.fixfis.sUHCore.items.SUHItems;
import me.fixfis.sUHCore.items.modItems.CrearItem;
import me.fixfis.sUHCore.mobs.SUHMobs;
import me.fixfis.sUHCore.sever_client.ClientUtils;
import me.fixfis.sUHCore.stuff.FCOMMANDS;
import me.fixfis.sUHCore.stuff.FLISTENER;
import me.fixfis.sUHCore.stuff.FTABCOMPLETER;
import me.fixfis.sUHCore.utils.config.FFileManager;
import me.fixfis.sUHCore.utils.logger.FLogger;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.JSONObject;

public final class SUHCore
extends JavaPlugin {
    private final int idPlugin = 15;
    public static SUHCore instance;
    private final FFileManager fileManager = new FFileManager(String.valueOf(this.getDataFolder()) + "/");
    private InitServer initServer;
    public static JSONObject FILEcraftings;
    public static JSONObject FILEmobs;
    public static JSONObject FILEevents;
    public static JSONObject FILEgenericconfig;

    public void onEnable() {
        instance = this;
        this.initServer = new InitServer(15, this, "suhcore", true);
        if (instance.getInitServer().getEstadoDeLicencia()) {
            FILEcraftings = this.fileManager.load(FFileManager.FILE.CRAFTING);
            FILEmobs = this.fileManager.load(FFileManager.FILE.MOBSFILE);
            FILEevents = this.fileManager.load(FFileManager.FILE.EVENTS_CONFIG);
            FILEgenericconfig = this.fileManager.load(FFileManager.FILE.GENERIC_CONFIG);
            this.runeable();
            this.initCommands();
            this.initSUHCore();
            FLogger.debugging("Plugin enabled!");
        }
    }

    public void onDisable() {
        if (instance.getInitServer().getEstadoDeLicencia()) {
            this.disableSUHCore();
            this.fileManager.save(FILEcraftings, FFileManager.FILE.CRAFTING);
            this.fileManager.save(FILEmobs, FFileManager.FILE.MOBSFILE);
            this.fileManager.save(FILEevents, FFileManager.FILE.EVENTS_CONFIG);
            this.fileManager.save(FILEgenericconfig, FFileManager.FILE.GENERIC_CONFIG);
            FLogger.debugging("Plugin disabled!");
            CrearItem.itemStackHashMap.forEach((key, value) -> {
                if (Bukkit.removeRecipe((NamespacedKey)new NamespacedKey((Plugin)this, key))) {
                    FLogger.info("Receta " + key + " eliminada!");
                }
            });
        }
    }

    void initCommands() {
        ClientUtils cliente = new ClientUtils();
        this.getCommand("suhcore").setExecutor((CommandExecutor)new FCOMMANDS());
        this.getCommand("suhf66").setExecutor((CommandExecutor)cliente);
        this.getCommand("suhcore").setTabCompleter((TabCompleter)new FTABCOMPLETER());
        this.getServer().getPluginManager().registerEvents((Listener)new FLISTENER(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)cliente, (Plugin)this);
    }

    void initSUHCore() {
        SUHItems.values();
        SUHMobs.values();
        for (SUHEvents sUHEvents : SUHEvents.values()) {
            sUHEvents.getCrearEvento().load();
        }
        for (Enum enum_ : SUHGenericConfig.values()) {
            ((SUHGenericConfig)enum_).getConfig().load();
        }
    }

    void disableSUHCore() {
        for (SUHEvents sUHEvents : SUHEvents.values()) {
            sUHEvents.getCrearEvento().save();
        }
        for (Enum enum_ : SUHGenericConfig.values()) {
            ((SUHGenericConfig)enum_).getConfig().save();
        }
        for (Enum enum_ : SUHMobs.values()) {
            ((SUHMobs)enum_).saveData();
        }
    }

    void runeable() {
        BukkitRunnable runnable = new BukkitRunnable(this){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player == null) continue;
                    for (int i = 0; i < CrearItem.artifacts.size(); ++i) {
                        if (!CrearItem.artifacts.get(i).hasPlayerThisItemInHotbar(player)) continue;
                        CrearItem.artifacts.get(i).scheduleThatDoesThisItem(player);
                    }
                }
            }
        };
        runnable.runTaskTimer((Plugin)this, 0L, 200L);
    }

    public InitServer getInitServer() {
        return this.initServer;
    }

    public FFileManager getFileManager() {
        return this.fileManager;
    }
}

