/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.items.modItems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.utils.logger.FLogger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.JSONArray;

public abstract class CrearItem
implements Listener {
    public static JSONArray blackListCraftings = SUHCore.FILEcraftings.getJSONArray("blackList");
    public static HashMap<String, ItemStack> itemStackHashMap = new HashMap();
    public static ArrayList<CrearItem> artifacts = new ArrayList();
    public static NamespacedKey customItemKey = new NamespacedKey((Plugin)SUHCore.instance, "custom_item");
    public HashMap<Player, Attribute> moddedPlayer = new HashMap();
    private ItemStack item;
    private String itemsName;
    private NamespacedKey key;

    public CrearItem(Material material, String keyName) {
        if (SUHCore.instance.getInitServer().getEstadoDeLicencia()) {
            SUHCore.instance.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)SUHCore.instance);
            ItemStack item = new ItemStack(material);
            ItemMeta meta = item.getItemMeta();
            this.key = new NamespacedKey((Plugin)SUHCore.instance, keyName);
            meta.getPersistentDataContainer().set(customItemKey, PersistentDataType.BOOLEAN, (Object)true);
            meta.getPersistentDataContainer().set(this.key, PersistentDataType.STRING, (Object)this.key.getKey());
            this.howsThisItemWouldLookLike(meta, this.key);
            item.setItemMeta(meta);
            this.applyDataComponentModifications(item, this.key);
            this.item = item;
            this.itemsName = meta.getDisplayName() == null ? "nullo" : meta.getDisplayName();
            ShapedRecipe recipe = new ShapedRecipe(this.key, item);
            this.createRecipe(recipe);
            if (this.isArtifact()) {
                artifacts.add(this);
            }
            try {
                for (Object object : blackListCraftings) {
                    String s;
                    if (!(object instanceof String) || !(s = (String)object).equalsIgnoreCase(this.key.getKey())) continue;
                    FLogger.info("Item prohibido de craftear a\u00f1adido: " + this.key.getKey());
                    itemStackHashMap.put(this.key.getKey(), item);
                    return;
                }
                if (Bukkit.getRecipe((NamespacedKey)this.key) == null) {
                    if (Bukkit.addRecipe((Recipe)recipe)) {
                        FLogger.info("Item crafteable a\u00f1adido: " + this.key.getKey());
                    }
                    itemStackHashMap.put(this.key.getKey(), item);
                }
            }
            catch (NullPointerException e) {
                itemStackHashMap.put(this.key.getKey(), item);
                FLogger.info("Item no crafteable a\u00f1adido: " + this.key.getKey());
            }
        }
    }

    @EventHandler
    public final void onRightClick(PlayerInteractEvent event) {
        if (this.isThisItem(event.getPlayer().getInventory().getItemInMainHand()) && event.getHand() == EquipmentSlot.HAND) {
            if (event.getAction() == Action.RIGHT_CLICK_AIR) {
                this.onRightClickAtAirEvent(event.getPlayer(), event.getPlayer().getInventory().getItemInMainHand(), event);
            } else if (event.getAction() == Action.LEFT_CLICK_AIR) {
                this.onLeftClickAtAirEvent(event.getPlayer(), event.getPlayer().getInventory().getItemInMainHand(), event);
            }
        }
    }

    @EventHandler
    public final void onRightClickAtEntity(PlayerInteractEntityEvent event) {
        if (this.isThisItem(event.getPlayer().getInventory().getItemInMainHand())) {
            this.onRightClickAtEntityEvent(event.getPlayer(), event.getRightClicked(), event.getPlayer().getInventory().getItemInMainHand(), event);
        }
    }

    @EventHandler
    public final void onCraft(CraftItemEvent event) {
        if (this.isThisItem(event.getRecipe().getResult())) {
            this.onCraftEvent(event);
        }
    }

    @EventHandler
    public final void onPlayerAttack(EntityDamageByEntityEvent event) {
        Player player;
        Entity entity = event.getDamager();
        if (entity instanceof Player && this.isThisItem((player = (Player)entity).getInventory().getItemInMainHand()) && (entity = event.getEntity()) instanceof Monster) {
            Monster monster = (Monster)entity;
            this.onPlayerDamageWithThisItem(player, monster, event);
        }
    }

    public final boolean isThisItem(ItemStack itemStack) {
        if (!itemStack.hasItemMeta()) {
            return false;
        }
        String valor = (String)itemStack.getItemMeta().getPersistentDataContainer().get(this.key, PersistentDataType.STRING);
        return valor != null && valor.equalsIgnoreCase(this.key.getKey());
    }

    public final boolean hasPlayerThisItem(Player player, int discount) {
        boolean has = false;
        for (ItemStack stack : player.getInventory().getContents()) {
            if (stack == null || !this.isThisItem(stack)) continue;
            has = true;
            stack.setAmount(stack.getAmount() - discount);
            break;
        }
        return has;
    }

    public final boolean hasPlayerThisItemInHotbar(Player player) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack == null || !this.isThisItem(stack)) continue;
            return true;
        }
        return false;
    }

    protected void modificarAtributoAlJugador(final Player player, final Attribute attribute, final Double value) {
        if (this.moddedPlayer.get(player) != null && this.moddedPlayer.get(player) == attribute) {
            return;
        }
        this.moddedPlayer.put(player, attribute);
        Objects.requireNonNull(player.getAttribute(attribute)).setBaseValue(Objects.requireNonNull(player.getAttribute(attribute)).getBaseValue() + value);
        new BukkitRunnable(){

            public void run() {
                if (!CrearItem.this.hasPlayerThisItemInHotbar(player) || !player.isConnected()) {
                    Objects.requireNonNull(player.getAttribute(attribute)).setBaseValue(Objects.requireNonNull(player.getAttribute(attribute)).getBaseValue() - value);
                    CrearItem.this.moddedPlayer.remove(player);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)SUHCore.instance, 0L, 20L);
    }

    public void scheduleThatDoesThisItem(Player player) {
        player.sendMessage("Schedule sin Attributos, llama a un admin");
    }

    protected abstract void howsThisItemWouldLookLike(ItemMeta var1, NamespacedKey var2);

    protected void applyDataComponentModifications(ItemStack item, NamespacedKey key) {
    }

    protected boolean isArtifact() {
        return false;
    }

    protected void createRecipe(ShapedRecipe recipe) {
    }

    protected void onRightClickAtAirEvent(Player player, ItemStack currentItem, PlayerInteractEvent event) {
    }

    protected void onLeftClickAtAirEvent(Player player, ItemStack currentItem, PlayerInteractEvent event) {
    }

    protected void onRightClickAtEntityEvent(Player player, Entity entity, ItemStack currentItem, PlayerInteractEntityEvent event) {
    }

    protected void onPlayerDamageWithThisItem(Player player, Monster monster, EntityDamageByEntityEvent event) {
    }

    protected void onCraftEvent(CraftItemEvent event) {
    }

    public final NamespacedKey getKey() {
        return this.key;
    }

    public final ItemStack getItem() {
        return this.item;
    }

    public String getItemsName() {
        return this.itemsName == null ? "nullo" : this.itemsName;
    }
}

