/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.mobs;

import java.util.List;
import java.util.Objects;
import me.fixfis.sUHCore.items.SUHItems;
import me.fixfis.sUHCore.mobs.modMobs.CrearMob;
import me.fixfis.sUHCore.mobs.modMobs.EntityAttributes;
import me.fixfis.sUHCore.sever_client.maps.EncadenadoMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public enum SUHMobs {
    PENECINIRIQUINI(new CrearMob(EntityType.SILVERFISH, "peneciniriquini"){

        @Override
        protected void howThisEntityWouldBe(Entity entity) {
            entity.setCustomName("Peneciniriquini");
        }

        @Override
        protected void thisEntityDrops(List<ItemStack> drops) {
            drops.add(new ItemStack(Material.NETHER_BRICK));
        }
    }),
    SKELETON_TP(new CrearMob(EntityType.SKELETON, "skeletonTp"){

        @Override
        protected void howThisEntityWouldBe(Entity entity) {
            if (entity instanceof Skeleton) {
                Skeleton skeleton = (Skeleton)entity;
                ItemStack helmet = new ItemStack(Material.END_STONE);
                helmet.editMeta(meta -> meta.setCustomModelData(Integer.valueOf(1)));
                skeleton.getEquipment().setHelmet(helmet);
                skeleton.setCustomName("Skeleton TP");
            }
        }

        @Override
        protected EntityAttributes putDefaultAttributes() {
            return EntityAttributes.SKELETON;
        }
    }),
    CREEPER_BOMBA(new CrearMob(EntityType.CREEPER, "creeperBomba"){

        @Override
        protected void howThisEntityWouldBe(Entity entity) {
            if (entity instanceof Creeper) {
                Creeper creeper = (Creeper)entity;
                creeper.getEquipment().setHelmet(new ItemStack(Material.PAPER));
            }
            entity.setCustomName("Crepersini Bobini");
        }

        @Override
        protected EntityAttributes putDefaultAttributes() {
            return EntityAttributes.CREEPER;
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Entity entity, Player player, EntityDamageByEntityEvent event) {
            player.sendMessage("da\u00f1ado");
            EncadenadoMap.addUser(player);
        }
    }),
    BLOOD_BAT(new CrearMob(EntityType.BAT, "bloodBat"){

        @Override
        protected void howThisEntityWouldBe(Entity entity) {
            entity.setCustomName("Murcielago de Sangre");
        }

        @Override
        protected void thisEntityDrops(List<ItemStack> drops) {
            drops.add(SUHItems.BOLSA_SANGRE.getItemStack());
        }
    }),
    ZOMBIE_TEST(new CrearMob(EntityType.ZOMBIE, "zombie_test"){

        @Override
        protected void howThisEntityWouldBe(Entity entity) {
            entity.setCustomName("test");
        }

        @Override
        protected EntityAttributes putDefaultAttributes() {
            return EntityAttributes.ZOMBIE;
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Entity entity, Player player, EntityDamageByEntityEvent event) {
            player.sendMessage("HOLAA");
        }
    }),
    ORE_TITANIUM(new CrearMob(EntityType.ZOMBIE, "oreTitanium"){

        @Override
        protected void howThisEntityWouldBe(Entity entity) {
            if (entity instanceof Zombie) {
                Zombie zombie = (Zombie)entity;
                zombie.setAI(false);
                zombie.setSilent(true);
                zombie.setInvisible(true);
                zombie.setBaby();
                Location location = zombie.getLocation();
                location.setPitch(0.0f);
                zombie.teleport(location);
                zombie.getEquipment().setHelmet(SUHItems.ORE_TITANIUM.getItemStack());
                Objects.requireNonNull(zombie.getAttribute(Attribute.SCALE)).setBaseValue(0.5);
            }
        }

        @Override
        protected void onThisEntityDamaged(Entity entity, EntityDamageEvent event) {
            event.setCancelled(true);
        }

        @Override
        protected void onThisEntityDamagedByPlayer(Entity entity, Player player, EntityDamageByEntityEvent event) {
            if (player.getInventory().getItemInMainHand().getType() == Material.DIAMOND_PICKAXE) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }

        @Override
        protected void thisEntityDrops(List<ItemStack> drops) {
            drops.clear();
            drops.add(SUHItems.ORE_TITANIUM.getItemStack());
        }

        @Override
        protected void onThisEntityDie(Entity entity, Player player, EntityDeathEvent event) {
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.getEquipment().setHelmet(null);
            }
        }
    }),
    MISION_ATTR(new CrearMob(EntityType.ARMOR_STAND, "misionAttr"){

        @Override
        protected void howThisEntityWouldBe(Entity entity) {
            if (entity instanceof ArmorStand) {
                ArmorStand armorStand = (ArmorStand)entity;
                armorStand.setCustomName("Mision Attr");
                armorStand.setCustomNameVisible(true);
                armorStand.setGravity(false);
                armorStand.setBasePlate(false);
                armorStand.setArms(false);
                armorStand.setVisible(false);
                armorStand.setInvulnerable(true);
                armorStand.getAttribute(Attribute.SCALE).setBaseValue(1.6);
                armorStand.getEquipment().setHelmet(SUHItems.ATTRILMISSIONS.getItemStack());
            }
        }
    });

    private final CrearMob crearMob;

    private SUHMobs(CrearMob crearMob) {
        this.crearMob = crearMob;
    }

    public CrearMob getCrearMob() {
        return this.crearMob;
    }

    public boolean isThisEntity(Entity entity) {
        return this.crearMob.isThisEntity(entity);
    }

    public void summonEntity(Player player) {
        this.crearMob.summonEntity(player.getLocation());
    }

    public void saveData() {
        this.crearMob.saveData();
    }

    public void loadData() {
        this.crearMob.loadData();
    }
}

