/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.mobs.modMobs;

import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.mobs.modMobs.EntityAttributes;
import org.json.JSONObject;

public class MobAttributes {
    private final EntityAttributes vanillaAttributes;
    private final String keyName;
    private Double spawn_prob;
    private Double health;
    private Double attack_damage;
    private Double armor;
    private Double scale;
    private Double follow_range;
    private Double speed;
    private Double jump;
    private Double knockback_resistance;
    private Double attack_knockback;
    private Boolean powered;
    private Integer ticks_to_explode;
    private Integer explosion_radius;

    public MobAttributes(String keyName, EntityAttributes vanillaAttributes) {
        this.keyName = keyName;
        this.vanillaAttributes = vanillaAttributes;
        this.load();
    }

    public MobAttributes(String keyName) {
        this.keyName = keyName;
        this.vanillaAttributes = null;
        this.loadProb();
    }

    public void loadProb() {
        JSONObject json = SUHCore.FILEmobs;
        if (json.has(this.keyName)) {
            JSONObject attr = json.getJSONObject(this.keyName);
            this.spawn_prob = attr.getDouble("spawn_prob");
        } else {
            this.spawn_prob = 0.0;
        }
    }

    public void saveProb() {
        JSONObject attr = SUHCore.FILEmobs.getJSONObject(this.keyName);
        attr.put("spawn_prob", this.spawn_prob);
        SUHCore.FILEmobs.put(this.keyName, attr);
    }

    public void load() {
        JSONObject json = SUHCore.FILEmobs;
        if (json.has(this.keyName)) {
            JSONObject attr = json.getJSONObject(this.keyName);
            this.health = attr.getDouble("health");
            this.attack_damage = attr.getDouble("attack_damage");
            this.armor = attr.getDouble("armor");
            this.scale = attr.getDouble("scale");
            this.follow_range = attr.getDouble("follow_range");
            this.speed = attr.getDouble("speed");
            this.jump = attr.getDouble("jump");
            this.knockback_resistance = attr.getDouble("knockback_resistance");
            this.attack_knockback = attr.getDouble("attack_knockback");
            if (attr.has("powered")) {
                this.powered = attr.getBoolean("powered");
                this.ticks_to_explode = attr.getInt("ticks_to_explode");
                this.explosion_radius = attr.getInt("explosion_radius");
            }
        } else {
            this.health = this.vanillaAttributes.getJson().getDouble("health");
            this.attack_damage = this.vanillaAttributes.getJson().getDouble("attack_damage");
            this.armor = this.vanillaAttributes.getJson().getDouble("armor");
            this.scale = this.vanillaAttributes.getJson().getDouble("scale");
            this.follow_range = this.vanillaAttributes.getJson().getDouble("follow_range");
            this.speed = this.vanillaAttributes.getJson().getDouble("speed");
            this.jump = this.vanillaAttributes.getJson().getDouble("jump");
            this.knockback_resistance = this.vanillaAttributes.getJson().getDouble("knockback_resistance");
            this.attack_knockback = this.vanillaAttributes.getJson().getDouble("attack_knockback");
            if (this.vanillaAttributes.getJson().has("powered")) {
                this.powered = this.vanillaAttributes.getJson().getBoolean("powered");
                this.ticks_to_explode = this.vanillaAttributes.getJson().getInt("ticks_to_explode");
                this.explosion_radius = this.vanillaAttributes.getJson().getInt("explosion_radius");
            }
        }
    }

    public void save() {
        JSONObject attr = SUHCore.FILEmobs.getJSONObject(this.keyName);
        attr.put("health", this.health);
        attr.put("attack_damage", this.attack_damage);
        attr.put("armor", this.armor);
        attr.put("scale", this.scale);
        attr.put("follow_range", this.follow_range);
        attr.put("speed", this.speed);
        attr.put("jump", this.jump);
        attr.put("knockback_resistance", this.knockback_resistance);
        attr.put("attack_knockback", this.attack_knockback);
        if (this.powered != null) {
            attr.put("powered", this.powered);
            attr.put("ticks_to_explode", this.ticks_to_explode);
            attr.put("explosion_radius", this.explosion_radius);
        }
        SUHCore.FILEmobs.put(this.keyName, attr);
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Double getSpawn_prob() {
        return this.spawn_prob;
    }

    public Double getHealth() {
        return this.health;
    }

    public Double getAttack_damage() {
        return this.attack_damage;
    }

    public Double getArmor() {
        return this.armor;
    }

    public Double getScale() {
        return this.scale;
    }

    public Double getFollow_range() {
        return this.follow_range;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public Double getJump() {
        return this.jump;
    }

    public Double getKnockback_resistance() {
        return this.knockback_resistance;
    }

    public Double getAttack_knockback() {
        return this.attack_knockback;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public int getTicks_to_explode() {
        return this.ticks_to_explode;
    }

    public Integer getExplosion_radius() {
        return this.explosion_radius;
    }

    public void setSpawn_prob(Double spawn_prob) {
        this.spawn_prob = spawn_prob;
    }
}

