/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.lootable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.lootable.LootDrawer;
import org.bukkit.entity.Player;
import org.json.JSONObject;

public class LootTable {
    public static Map<UUID, List<UUID>> lootables = new HashMap<UUID, List<UUID>>();

    public static void openLootToPlayer(UUID uuid, Player player, LootDrawer.LootType type, int lootTypeIndex, double rarityPerSlot) {
        if (lootables.containsKey(uuid) && !lootables.get(uuid).contains(player.getUniqueId())) {
            lootables.get(uuid).add(player.getUniqueId());
            new LootDrawer(type, lootTypeIndex, rarityPerSlot).openInv(player);
        }
    }

    public static void load() {
        JSONObject json = SUHCore.FILElootable;
        if (json.has("lootables")) {
            JSONObject loot = json.getJSONObject("lootables");
            for (String s : loot.keySet()) {
                UUID uuid = UUID.fromString(s);
                List<Object> list = loot.getJSONArray(s).toList();
                ArrayList<UUID> users = new ArrayList<UUID>();
                for (Object o : list) {
                    if (!(o instanceof String)) continue;
                    String ss = (String)o;
                    users.add(UUID.fromString(ss));
                }
                lootables.put(uuid, users);
            }
        }
    }

    public static void save() {
        JSONObject json = new JSONObject();
        for (UUID uuid : lootables.keySet()) {
            List<UUID> users = lootables.get(uuid);
            json.put(uuid.toString(), users);
        }
        SUHCore.FILElootable.put("lootables", json);
    }
}

