/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.mobs;

import io.papermc.paper.datacomponent.DataComponentTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.items.SUHItems;
import me.fixfis.sUHCore.lootable.LootDrawer;
import me.fixfis.sUHCore.lootable.LootTable;
import me.fixfis.sUHCore.mobs.modMobs.EntityAttributes;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FEntity;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FLivingEntities;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FMonster;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FStandEntity;
import me.fixfis.sUHCore.mobs.modMobs.mobs.special.SpecialAbilities;
import me.fixfis.sUHCore.muertes.interfaz.RevivirIntefaz;
import me.fixfis.sUHCore.sever_client.ClientUtils;
import me.fixfis.sUHCore.sever_client.maps.EncadenadoMap;
import net.kyori.adventure.key.Key;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public enum SUHMobs {
    LOBO_SANGRIENTO((FEntity<? extends Entity>)new FMonster<Wolf>(Wolf.class, "loboSangriento", null){

        @Override
        public void initViewMonster(Wolf entity) {
            entity.setCustomNameVisible(true);
            entity.setCustomName("Lobo Sangriento");
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Wolf entity, Player player, EntityDamageByEntityEvent event) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 100, 2, false, false));
        }
    }),
    KCAFETERO((FEntity<? extends Entity>)new FLivingEntities<Rabbit>(Rabbit.class, "kcafetero"){

        @Override
        protected void initViewPeaceful(Rabbit entity) {
            entity.getEquipment().setHelmet(2.getInvibleHelmet(Material.STICK));
            entity.getAttribute(Attribute.FALL_DAMAGE_MULTIPLIER).setBaseValue(0.0);
            entity.getAttribute(Attribute.KNOCKBACK_RESISTANCE).setBaseValue(0.0);
        }

        @Override
        protected void onThisEntityDamaged(Rabbit entity, EntityDamageEvent event) {
            entity.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 100, 2, false, false));
            entity.addPotionEffect(new PotionEffect(PotionEffectType.JUMP_BOOST, 100, 1, false, false));
        }

        @Override
        protected void thisEntityDrops(List<ItemStack> drops) {
            drops.clear();
            drops.add(SUHItems.CAFE.getItemStack());
        }
    }),
    ZOMBIE_SCRAMBLE((FEntity<? extends Entity>)new FMonster<Zombie>(Zombie.class, "zombieScramble", EntityAttributes.ZOMBIE){

        @Override
        public void initViewMonster(Zombie entity) {
            entity.getEquipment().setHelmet(3.getItemstackWhitItemModel(Material.STICK, "rubik"));
            entity.setCustomName("Zombie Scramble");
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Zombie entity, Player player, EntityDamageByEntityEvent event) {
            SpecialAbilities.ABILITY_SCRAMBLE_TO_PLAYER.getSpecialClass().doThis(player, (Monster)entity);
        }
    }),
    ZOMBIE_THROWER((FEntity<? extends Entity>)new FMonster<Zombie>(Zombie.class, "zombieThrower", EntityAttributes.ZOMBIE){

        @Override
        public void initViewMonster(Zombie entity) {
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Zombie entity, Player player, EntityDamageByEntityEvent event) {
            SpecialAbilities.ABILITY_FIRE_BALL.getSpecialClass().doThis(player, (Monster)entity);
        }
    }),
    SKELETON_COBWEB((FEntity<? extends Entity>)new FMonster<Skeleton>(Skeleton.class, "skeletonCobweb", EntityAttributes.SKELETON){

        @Override
        public void initViewMonster(Skeleton entity) {
            entity.getEquipment().setHelmet(5.getInvibleHelmet(Material.COBWEB));
            entity.setCustomName("Skeleton Cobweb");
        }

        @Override
        protected void onPlayerDamagedByThisEntityByArrow(Arrow arrow, Skeleton entity, Player player, EntityDamageByEntityEvent event) {
            player.getLocation().getBlock().setType(Material.COBWEB);
        }
    }),
    SKELETON_TP((FEntity<? extends Entity>)new FMonster<Skeleton>(Skeleton.class, "skeletonTpwa", EntityAttributes.SKELETON){

        @Override
        public void initViewMonster(Skeleton entity) {
            entity.getEquipment().setHelmet(6.getInvibleHelmet(Material.END_STONE));
            entity.setCustomName("Skeleton TP");
        }

        @Override
        protected void onPlayerDamagedByThisEntityByArrow(Arrow arrow, Skeleton entity, Player player, EntityDamageByEntityEvent event) {
            SpecialAbilities.ABILITY_SWITCH_LOCATION.getSpecialClass().doThis(player, (Monster)entity);
        }
    }),
    SKELETON_RAYO((FEntity<? extends Entity>)new FMonster<Skeleton>(Skeleton.class, "skeletonrayo", EntityAttributes.SKELETON){

        @Override
        public void initViewMonster(Skeleton entity) {
            entity.setCustomNameVisible(true);
            entity.setCustomName("Skeleton Rayo");
        }

        @Override
        protected void onPlayerDamagedByThisEntityByArrow(Arrow arrow, Skeleton entity, Player player, EntityDamageByEntityEvent event) {
            player.getWorld().spawn(player.getLocation(), LightningStrike.class);
        }
    }),
    CREEPER_SCRAMBLE((FEntity<? extends Entity>)new FMonster<Creeper>(Creeper.class, "creeperScramble", EntityAttributes.CREEPER){
        private final Map<UUID, BukkitRunnable> scramblePlayers = new HashMap<UUID, BukkitRunnable>();

        @Override
        public void initViewMonster(Creeper entity) {
            entity.getEquipment().setHelmet(8.getInvibleHelmet(Material.SLIME_BALL));
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Creeper entity, final Player player, EntityDamageByEntityEvent event) {
            BukkitRunnable task = new BukkitRunnable(){

                public void run() {
                    scramblePlayers.remove(player.getUniqueId());
                    ClientUtils.sendDataToClient(player, "scrambled", 0);
                }
            };
            if (this.scramblePlayers.containsKey(player.getUniqueId())) {
                this.scramblePlayers.get(player.getUniqueId()).cancel();
            }
            ClientUtils.sendDataToClient(player, "scrambled", 1);
            task.runTaskLater((Plugin)SUHCore.instance, 140L);
            this.scramblePlayers.put(player.getUniqueId(), task);
        }
    }),
    CREEPER_TNT((FEntity<? extends Entity>)new FMonster<Creeper>(Creeper.class, "creeper_tnt", EntityAttributes.CREEPER){

        @Override
        public void initViewMonster(Creeper entity) {
            entity.getEquipment().setHelmet(9.getInvibleHelmet(Material.TNT));
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Creeper entity, Player player, EntityDamageByEntityEvent event) {
            player.playSound((Entity)player, "entity.tin", 1.0f, 1.0f);
        }
    }),
    CREEPER_BOMBA((FEntity<? extends Entity>)new FMonster<Creeper>(Creeper.class, "creeperBomba", EntityAttributes.CREEPER){

        @Override
        public void initViewMonster(Creeper entity) {
            entity.getEquipment().setHelmet(new ItemStack(Material.PAPER));
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Creeper entity, Player player, EntityDamageByEntityEvent event) {
            EncadenadoMap.addUser(player);
        }
    }),
    CREEPER_FLASH((FEntity<? extends Entity>)new FMonster<Creeper>(Creeper.class, "creeper_flash", EntityAttributes.CREEPER){

        @Override
        public void initViewMonster(Creeper entity) {
            entity.getEquipment().setHelmet(new ItemStack(Material.STICK));
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Creeper entity, Player player, EntityDamageByEntityEvent event) {
            ClientUtils.sendDataToClient(player, "flashed", 1);
            player.playSound((Entity)player, "entity.tin", 1.0f, 1.0f);
        }
    }),
    BLOOD_BAT((FEntity<? extends Entity>)new FLivingEntities<Bat>(Bat.class, "blood_bat"){

        @Override
        protected void initViewPeaceful(Bat entity) {
            entity.getEquipment().setHelmet(new ItemStack(Material.STICK));
        }

        @Override
        protected void thisEntityDrops(List<ItemStack> drops) {
            drops.clear();
            drops.add(SUHItems.BOLSA_SANGRE.getItemStack());
        }

        @Override
        protected void onThisEntityDieByPlayer(Bat entity, Player player) {
            ((TNTPrimed)entity.getWorld().spawn(entity.getLocation(), TNTPrimed.class)).setFuseTicks(0);
        }
    }),
    ORE_TITANIUM((FEntity<? extends Entity>)new FLivingEntities<Zombie>(Zombie.class, "ore_titanium"){

        @Override
        protected void initViewPeaceful(Zombie entity) {
            entity.setAI(false);
            entity.setSilent(true);
            entity.setInvisible(true);
            entity.setBaby();
            Location location = entity.getLocation();
            location.setPitch(0.0f);
            entity.teleport(location);
            entity.getEquipment().setHelmet(SUHItems.ORE_TITANIUM.getItemStack());
            Objects.requireNonNull(entity.getAttribute(Attribute.SCALE)).setBaseValue(0.5);
        }

        @Override
        protected void onThisEntityDamaged(Zombie entity, EntityDamageEvent event) {
            event.setCancelled(true);
        }

        @Override
        protected void onThisEntityDamagedByPlayer(Zombie entity, Player player, EntityDamageByEntityEvent event) {
            if (player.getInventory().getItemInMainHand().getType() == Material.DIAMOND_PICKAXE) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
    }),
    MISIONATTRIL(new FStandEntity("misionattril"){

        @Override
        protected void initViewStand(ArmorStand entity) {
            entity.setCustomName("Mision Attr");
            entity.setCustomNameVisible(true);
            entity.setGravity(false);
            entity.setBasePlate(false);
            entity.setArms(false);
            entity.setVisible(false);
            entity.setInvulnerable(true);
            entity.getAttribute(Attribute.SCALE).setBaseValue(1.6);
            entity.getEquipment().setHelmet(SUHItems.MISION_STAND.getItemStack());
        }

        @Override
        protected void onRightClickAtEntityEvent(Player player, ArmorStand entity, PlayerInteractAtEntityEvent event) {
            player.sendMessage("dado");
        }
    }),
    PORTAL(new FStandEntity("portal"){

        @Override
        protected void initViewStand(ArmorStand entity) {
            entity.setSmall(true);
            entity.getAttribute(Attribute.SCALE).setBaseValue(4.0);
            ItemStack stack = new ItemStack(Material.STICK);
            stack.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)"suhcore", (String)"portal"));
            entity.getEquipment().setHelmet(15.getItemstackWhitItemModel(Material.STICK, "portal"));
        }

        @Override
        protected void onRightClickAtEntityEvent(Player player, ArmorStand entity, PlayerInteractAtEntityEvent event) {
            new RevivirIntefaz(player);
        }
    }),
    PORTAL_MINIGAMES(new FStandEntity("minigames"){

        @Override
        protected void initViewStand(ArmorStand entity) {
            entity.setSmall(true);
            entity.getAttribute(Attribute.SCALE).setBaseValue(20.0);
            ItemStack stack = new ItemStack(Material.STICK);
            stack.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)"suhcore", (String)"minigames_zone"));
            entity.getEquipment().setHelmet(16.getItemstackWhitItemModel(Material.STICK, "portal"));
        }
    }),
    LOOTCHEST(new FStandEntity("lootchest"){

        @Override
        protected void initViewStand(ArmorStand entity) {
            entity.getEquipment().setHelmet(17.getItemstackWhitItemModel(Material.STICK, "chest"));
            LootTable.lootables.put(entity.getUniqueId(), new ArrayList());
        }

        @Override
        protected void onRightClickAtEntityEvent(Player player, ArmorStand entity, PlayerInteractAtEntityEvent event) {
            LootTable.openLootToPlayer(entity.getUniqueId(), player, LootDrawer.LootType.abajo, 0, 0.3);
        }
    });

    private final FEntity<? extends Entity> fEntity;

    private SUHMobs(FEntity<? extends Entity> fEntity) {
        this.fEntity = fEntity;
    }

    public FEntity<? extends Entity> getfEntity() {
        return this.fEntity;
    }

    public void saveData() {
        FLivingEntities fMonster;
        FEntity<? extends Entity> fEntity = this.fEntity;
        if (fEntity instanceof FLivingEntities) {
            fMonster = (FLivingEntities)fEntity;
            fMonster.saveProb();
        }
        if ((fEntity = this.fEntity) instanceof FMonster) {
            fMonster = (FMonster)fEntity;
            ((FMonster)fMonster).saveData();
        }
    }

    public void loadData() {
        FLivingEntities fMonster;
        FEntity<? extends Entity> fEntity = this.fEntity;
        if (fEntity instanceof FLivingEntities) {
            fMonster = (FLivingEntities)fEntity;
            fMonster.loadProb();
        }
        if ((fEntity = this.fEntity) instanceof FMonster) {
            fMonster = (FMonster)fEntity;
            ((FMonster)fMonster).loadData();
        }
    }
}

