/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.items.modItems.newItems;

import java.util.Set;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.items.modItems.newItems.FItemStask;
import me.fixfis.sUHCore.items.modItems.newItems.en.FItemEvents;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class FItemEvent
extends FItemStask
implements Listener {
    private final boolean RIGHT_CLICK_EVENT;
    private final boolean RIGHT_CLICK_ENTITY_EVENT;
    private final boolean LEFT_CLICK_ENTITY_EVENT;
    private final boolean LEFT_CLICK_EVENT;
    private final boolean EAT_EVENT;

    public FItemEvent(Material material) {
        super(material);
        SUHCore.instance.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)SUHCore.instance);
        this.RIGHT_CLICK_EVENT = this.setEvents().contains((Object)FItemEvents.RIGHT_CLICK_EVENT);
        this.RIGHT_CLICK_ENTITY_EVENT = this.setEvents().contains((Object)FItemEvents.RIGHT_CLICK_ENTITY_EVENT);
        this.LEFT_CLICK_ENTITY_EVENT = this.setEvents().contains((Object)FItemEvents.LEFT_CLICK_ENTITY_EVENT);
        this.LEFT_CLICK_EVENT = this.setEvents().contains((Object)FItemEvents.LEFT_CLICK_EVENT);
        this.EAT_EVENT = this.setEvents().contains((Object)FItemEvents.EAT_EVENT);
    }

    protected abstract Set<FItemEvents> setEvents();

    @EventHandler
    public final void onEatThis(PlayerItemConsumeEvent event) {
        if (!this.EAT_EVENT) {
            return;
        }
        if (this.isThisItem(event.getItem())) {
            this.onPlayerConsumeThis(event.getPlayer(), event.getItem(), event);
        }
    }

    public void onPlayerConsumeThis(Player player, ItemStack currentItem, PlayerItemConsumeEvent event) {
    }

    @EventHandler
    public final void onRightClick(PlayerInteractEvent event) {
        if (!this.RIGHT_CLICK_EVENT && !this.LEFT_CLICK_EVENT) {
            return;
        }
        ItemStack hand = event.getPlayer().getInventory().getItemInMainHand();
        if (this.isThisItem(hand) && event.getHand() == EquipmentSlot.HAND) {
            if (event.getAction() == Action.RIGHT_CLICK_AIR && !event.getPlayer().hasCooldown(hand)) {
                this.onRightClickAirEvent(event.getPlayer(), hand, event);
            } else if (event.getAction() == Action.LEFT_CLICK_AIR) {
                this.onLeftClickAirEvent(event.getPlayer(), hand, event);
            }
            event.setCancelled(true);
        }
    }

    public void onRightClickAirEvent(Player player, ItemStack currentItem, PlayerInteractEvent event) {
    }

    public void onLeftClickAirEvent(Player player, ItemStack currentItem, PlayerInteractEvent event) {
    }

    @EventHandler
    public final void onRightClickAtEntity(PlayerInteractAtEntityEvent event) {
        if (!this.RIGHT_CLICK_ENTITY_EVENT) {
            return;
        }
        ItemStack hand = event.getPlayer().getInventory().getItemInMainHand();
        if (this.isThisItem(hand) && !event.getPlayer().hasCooldown(hand)) {
            this.onRightClickAtEntityEvent(event.getPlayer(), event.getRightClicked(), hand, event);
        }
    }

    public void onRightClickAtEntityEvent(Player player, Entity entity, ItemStack hand, PlayerInteractAtEntityEvent event) {
    }

    @EventHandler
    public final void onPlayerAttack(EntityDamageByEntityEvent event) {
        Player player;
        if (!this.LEFT_CLICK_ENTITY_EVENT) {
            return;
        }
        Entity entity = event.getDamager();
        if (entity instanceof Player && this.isThisItem((player = (Player)entity).getInventory().getItemInMainHand()) && (entity = event.getEntity()) instanceof Mob) {
            Mob monster = (Mob)entity;
            this.onLeftClickAtEntity(player, monster, event);
        }
    }

    public void onLeftClickAtEntity(Player player, Mob monster, EntityDamageByEntityEvent event) {
    }
}

