/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.mobs.modMobs.mobs.special;

import java.util.ArrayList;
import java.util.Collections;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.mobs.SUHMobs;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FEntity;
import me.fixfis.sUHCore.mobs.modMobs.mobs.special.SpecialClass;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public enum SpecialAbilities {
    PUT_FIRE_PLAYER(new SpecialClass(Type.BASIC){

        @Override
        public void doThis(Player player, Monster entity) {
            player.setFireTicks(100);
            player.getLocation().getBlock().setType(Material.FIRE);
        }
    }),
    PUT_WEAKNESS_PLAYER(new SpecialClass(Type.BASIC){

        @Override
        public void doThis(Player player, Monster entity) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 100, 1));
        }
    }),
    PUT_SLOWNESS_PLAYER(new SpecialClass(Type.BASIC){

        @Override
        public void doThis(Player player, Monster entity) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 100, 1));
        }
    }),
    PUT_BLINDNESS_PLAYER(new SpecialClass(Type.NORMAL){

        @Override
        public void doThis(Player player, Monster entity) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 1));
        }
    }),
    PUT_POSION_PLAYER(new SpecialClass(Type.BASIC){

        @Override
        public void doThis(Player player, Monster entity) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 100, 1));
        }
    }),
    PUT_PLAYER_COBWEB(new SpecialClass(Type.NORMAL){

        @Override
        public void doThis(Player player, Monster entity) {
            player.getLocation().getBlock().setType(Material.COBWEB);
        }
    }),
    ABILITY_ZOMBISITOS(new SpecialClass(Type.NORMAL){

        @Override
        public void doThis(Player player, Monster entity) {
            Zombie z = (Zombie)entity.getWorld().spawnEntity(entity.getLocation(), EntityType.ZOMBIE);
            z.setBaby();
            z.setTarget((LivingEntity)player);
        }
    }),
    ABILITY_CREEPERSITOSFLASH(new SpecialClass(Type.OP){

        @Override
        public void doThis(final Player player, final Monster entity) {
            if (!(SUHCore.random.nextDouble() < 0.2)) {
                return;
            }
            entity.setVelocity(entity.getLocation().getDirection().multiply(-2).setY(0.3));
            new BukkitRunnable(this){

                public void run() {
                    FEntity.particleToEntity((Entity)entity, Particle.HAPPY_VILLAGER);
                    Creeper creeper = (Creeper)SUHMobs.CREEPER_FLASH.getfEntity().summonEntity(entity.getLocation());
                    creeper.getAttribute(Attribute.SCALE).setBaseValue(0.5);
                    creeper.setTarget((LivingEntity)player);
                    creeper.setMaxFuseTicks(creeper.getMaxFuseTicks() - 5);
                }
            }.runTaskLater((Plugin)SUHCore.instance, 1L);
        }
    }),
    ABILITY_SWITCH_LOCATION(new SpecialClass(Type.SUPERIOR){

        @Override
        public void doThis(Player player, Monster entity) {
            Location location = entity.getLocation();
            FEntity.particleToEntity((Entity)entity, Particle.END_ROD);
            location.getWorld().spawnEntity(location, EntityType.EVOKER_FANGS);
            entity.teleport(player.getLocation());
            player.teleport(location);
        }
    }),
    ABILITY_SCRAMBLE_TO_PLAYER(new SpecialClass(Type.OP){

        @Override
        public void doThis(Player player, Monster entity) {
            FEntity.particleToEntity((Entity)entity, Particle.CAMPFIRE_COSY_SMOKE);
            entity.remove();
            PlayerInventory inventory = player.getInventory();
            ArrayList<ItemStack> itemsToShuffle = new ArrayList<ItemStack>();
            for (int slot = 0; slot <= 35; ++slot) {
                itemsToShuffle.add(inventory.getItem(slot));
            }
            itemsToShuffle.add(inventory.getItem(40));
            Collections.shuffle(itemsToShuffle);
            int index = 0;
            for (int slot = 0; slot <= 35; ++slot) {
                inventory.setItem(slot, (ItemStack)itemsToShuffle.get(index++));
            }
            inventory.setItem(40, (ItemStack)itemsToShuffle.get(index));
        }
    }),
    ABILITY_FIRE_BALL(new SpecialClass(Type.OP){

        @Override
        public void doThis(Player player, final Monster entity) {
            final Location spawnLoc = entity.getLocation().add(0.0, entity.getHeight() + 1.0, 0.0);
            final Vector direction = player.getLocation().add(0.0, player.getHeight() / 2.0, 0.0).toVector().subtract(spawnLoc.toVector()).normalize();
            entity.setVelocity(entity.getLocation().getDirection().multiply(-2).setY(0.3));
            new BukkitRunnable(this){

                public void run() {
                    Fireball fireball = (Fireball)entity.getWorld().spawn(spawnLoc, Fireball.class);
                    fireball.setDirection(direction);
                    fireball.setYield(2.0f);
                    fireball.setIsIncendiary(false);
                }
            }.runTaskLater((Plugin)SUHCore.instance, 5L);
        }
    }),
    ABILITY_EMPUJAR(new SpecialClass(Type.SUPERIOR){

        @Override
        public void doThis(final Player player, Monster entity) {
            final Vector velocity = entity.getLocation().getDirection().multiply(2).setY(1);
            new BukkitRunnable(this){

                public void run() {
                    player.setVelocity(velocity);
                }
            }.runTaskLater((Plugin)SUHCore.instance, 1L);
        }
    });

    private final SpecialClass specialClass;

    private SpecialAbilities(SpecialClass specialClass) {
        this.specialClass = specialClass;
    }

    public SpecialClass getSpecialClass() {
        return this.specialClass;
    }

    public static enum Type {
        BASIC,
        NORMAL,
        SUPERIOR,
        OP;

    }
}

