/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.items.modItems;

import java.util.ArrayList;
import java.util.List;
import me.fixfis.sUHCore.SUHCore;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemsUtils {
    private static final NamespacedKey usedForMisionNameSpace = new NamespacedKey((Plugin)SUHCore.instance, "used_for_mision");

    public static void hasBeenUsedForMission(ItemStack currentItem, Player player) {
        currentItem.editMeta(itemMeta -> itemMeta.getPersistentDataContainer().set(usedForMisionNameSpace, PersistentDataType.STRING, (Object)player.getName().toLowerCase()));
    }

    public static void hasNotBeenUsedForMission(ItemStack currentItem) {
        currentItem.editMeta(itemMeta -> itemMeta.getPersistentDataContainer().remove(usedForMisionNameSpace));
    }

    public static List<String> getPersitantData(ItemStack stack) {
        ArrayList list = new ArrayList();
        stack.getItemMeta().getPersistentDataContainer().getKeys().forEach(namespacedKey -> {
            String value = ItemsUtils.getPersistentDataValue(stack, namespacedKey);
            list.add(namespacedKey.getKey() + "@" + value);
        });
        return list.stream().toList();
    }

    private static String getPersistentDataValue(ItemStack stack, NamespacedKey key) {
        PersistentDataContainer container = stack.getItemMeta().getPersistentDataContainer();
        try {
            String stringValue = (String)container.get(key, PersistentDataType.STRING);
            if (stringValue != null) {
                return stringValue;
            }
        }
        catch (IllegalArgumentException stringValue) {
            // empty catch block
        }
        try {
            Byte byteValue = (Byte)container.get(key, PersistentDataType.BYTE);
            if (byteValue != null) {
                return byteValue.toString();
            }
        }
        catch (IllegalArgumentException byteValue) {
            // empty catch block
        }
        try {
            Integer intValue = (Integer)container.get(key, PersistentDataType.INTEGER);
            if (intValue != null) {
                return intValue.toString();
            }
        }
        catch (IllegalArgumentException intValue) {
            // empty catch block
        }
        try {
            Double doubleValue = (Double)container.get(key, PersistentDataType.DOUBLE);
            if (doubleValue != null) {
                return doubleValue.toString();
            }
        }
        catch (IllegalArgumentException doubleValue) {
            // empty catch block
        }
        try {
            Float floatValue = (Float)container.get(key, PersistentDataType.FLOAT);
            if (floatValue != null) {
                return floatValue.toString();
            }
        }
        catch (IllegalArgumentException floatValue) {
            // empty catch block
        }
        try {
            Long longValue = (Long)container.get(key, PersistentDataType.LONG);
            if (longValue != null) {
                return longValue.toString();
            }
        }
        catch (IllegalArgumentException longValue) {
            // empty catch block
        }
        try {
            Short shortValue = (Short)container.get(key, PersistentDataType.SHORT);
            if (shortValue != null) {
                return shortValue.toString();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return "unknown_type";
    }
}

