/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.mobs.modMobs.mobs;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.fixfis.sUHCore.mobs.modMobs.MobAttributes;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FEntity;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Husk;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public abstract class FLivingEntities<T extends Mob>
extends FEntity<T>
implements Listener {
    private final MobAttributes mobProb;
    private double spawn_prob = 0.0;
    private boolean dropEquipment = false;
    private List<Class<? extends LivingEntity>> kindOfEntity = new ArrayList<Class<? extends LivingEntity>>();

    public FLivingEntities(Class<T> claseEntidad, String keyName) {
        super(claseEntidad, keyName);
        if (claseEntidad.isInstance(Zombie.class)) {
            this.kindOfEntity.add(Husk.class);
            this.kindOfEntity.add(Drowned.class);
            this.kindOfEntity.add(Zombie.class);
        } else if (claseEntidad.isInstance(Skeleton.class)) {
            this.kindOfEntity.add(Skeleton.class);
            this.kindOfEntity.add(Stray.class);
        }
        this.mobProb = new MobAttributes(keyName);
        this.spawn_prob = this.mobProb.getSpawn_prob();
    }

    @Override
    protected final void initViewEntity(T entity) {
        this.dropEquipament(entity);
        entity.setPersistent(false);
        this.initViewPeaceful(entity);
    }

    @EventHandler
    public final void onDamageEvent(EntityDamageByEntityEvent event) {
        this.onDamage(event);
    }

    protected void onDamage(EntityDamageByEntityEvent event) {
        if (this.isThisEntity(event.getEntity())) {
            Entity entity = event.getDamager();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.onThisEntityDamagedByPlayer((Mob)this.claseEntidad.cast(event.getEntity()), player, event);
            } else {
                Arrow arrow;
                entity = event.getDamager();
                if (entity instanceof Arrow && (entity = (arrow = (Arrow)entity).getShooter()) instanceof Player) {
                    Player player = (Player)entity;
                    this.onThisEntityDamagedByPlayerByArrow(arrow, (Mob)this.claseEntidad.cast(event.getEntity()), player, event);
                }
            }
        }
    }

    @EventHandler
    public final void onThisSpawn(CreatureSpawnEvent event) {
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM) {
            return;
        }
        if (this.claseEntidad.isInstance(event.getEntity())) {
            Random random = new Random();
            if ((double)((int)(random.nextDouble() * 100.0)) < this.spawn_prob) {
                if (!event.getEntity().getScoreboardTags().isEmpty()) {
                    return;
                }
                this.onThisEntitySpawn((Mob)this.claseEntidad.cast(event.getEntity()), (EntitySpawnEvent)event);
                this.setView((Mob)this.claseEntidad.cast(event.getEntity()));
            }
        }
    }

    @Override
    public boolean isThisEntity(Entity entity) {
        if (!entity.getScoreboardTags().contains(this.getKeyName())) {
            return false;
        }
        if (this.kindOfEntity.isEmpty()) {
            return this.claseEntidad.isInstance(entity) && entity.getScoreboardTags().contains(this.getKeyName());
        }
        for (Class<? extends LivingEntity> value : this.kindOfEntity) {
            if (!value.isInstance(entity)) continue;
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onEntityDamaged(EntityDamageEvent event) {
        if (this.isThisEntity(event.getEntity())) {
            this.onThisEntityDamaged((Mob)this.claseEntidad.cast(event.getEntity()), event);
        }
    }

    @EventHandler
    public final void onThisDead(EntityDeathEvent event) {
        if (this.isThisEntity((Entity)event.getEntity())) {
            this.onThisEntityDie((Mob)this.claseEntidad.cast(event.getEntity()));
            if (event.getEntity().getKiller() == null) {
                return;
            }
            this.onThisEntityDieByPlayer((Mob)this.claseEntidad.cast(event.getEntity()), event.getEntity().getKiller());
            this.thisEntityDrops(event.getDrops());
        }
    }

    private void dropEquipament(T entity) {
        if (this.dropEquipment) {
            entity.getEquipment();
            entity.setCanPickupItems(false);
            entity.getEquipment().setDropChance(EquipmentSlot.HEAD, 0.0f);
            entity.getEquipment().setDropChance(EquipmentSlot.CHEST, 0.0f);
            entity.getEquipment().setDropChance(EquipmentSlot.LEGS, 0.0f);
            entity.getEquipment().setDropChance(EquipmentSlot.FEET, 0.0f);
        }
    }

    protected abstract void initViewPeaceful(T var1);

    protected void onThisEntitySpawn(T entity, EntitySpawnEvent event) {
    }

    protected void thisEntityDrops(List<ItemStack> drops) {
    }

    protected void onThisEntityDieByPlayer(T entity, Player player) {
    }

    protected void onThisEntityDie(T entity) {
    }

    protected void onThisEntityDamagedByPlayerByArrow(Arrow arrow, T entity, Player player, EntityDamageByEntityEvent event) {
    }

    protected void onThisEntityDamagedByPlayer(T entity, Player player, EntityDamageByEntityEvent event) {
    }

    public final void setDropEquipment(boolean dropEquipment) {
        this.dropEquipment = dropEquipment;
    }

    protected void onThisEntityDamaged(T entity, EntityDamageEvent event) {
    }

    public void loadProb() {
        this.mobProb.loadProb();
        this.spawn_prob = this.mobProb.getSpawn_prob();
    }

    public void saveProb() {
        this.mobProb.setSpawn_prob(this.spawn_prob);
        this.mobProb.saveProb();
    }

    public final void setSpawn_prob(double spawn_prob) {
        this.spawn_prob = spawn_prob;
    }
}

