/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.mobs.modMobs.mobs;

import me.fixfis.sUHCore.lootable.LootDrawer;
import me.fixfis.sUHCore.lootable.LootTable;
import me.fixfis.sUHCore.utils.logger.FLogger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class FLootEntity {
    public static void summonEntity(Location l, LootDrawer lootDrawer, CHESTS chests) {
        ArmorStand stand = (ArmorStand)l.getWorld().spawn(l, ArmorStand.class);
        stand.addDisabledSlots(new EquipmentSlot[]{EquipmentSlot.HEAD});
        stand.addDisabledSlots(new EquipmentSlot[]{EquipmentSlot.CHEST});
        stand.addDisabledSlots(new EquipmentSlot[]{EquipmentSlot.LEGS});
        stand.addDisabledSlots(new EquipmentSlot[]{EquipmentSlot.FEET});
        stand.setGravity(false);
        stand.setBasePlate(false);
        stand.setArms(false);
        stand.setVisible(false);
        stand.setInvulnerable(true);
        stand.setSmall(true);
        ItemStack model = new ItemStack(Material.STICK);
        model.editMeta(m -> m.setItemModel(new NamespacedKey("lootcrat_plus", chests.getItemModel())));
        stand.getEquipment().setHelmet(model);
        stand.getScoreboardTags().add("lootchest");
        stand.getScoreboardTags().add("loottype:" + lootDrawer.lootType().name());
        stand.getScoreboardTags().add("rarityperslot:" + lootDrawer.rarityPerSlot());
        stand.getScoreboardTags().add("lootindex:" + lootDrawer.lootTypeIndex());
        FLogger.debugging("LootChest spawned at: " + String.valueOf(l) + " , that it was an" + lootDrawer.toString());
    }

    public static void onDectectedLoot(ArmorStand armorStand, Player player) {
        LootDrawer.LootType type;
        if (!armorStand.getScoreboardTags().contains("lootchest")) {
            return;
        }
        String lootType = "superficie";
        double rarityPerSlot = 0.15;
        int lootIndex = 0;
        for (String tag : armorStand.getScoreboardTags()) {
            if (tag.startsWith("loottype:")) {
                lootType = tag.replace("loottype:", "");
                continue;
            }
            if (tag.startsWith("rarityperslot:")) {
                try {
                    rarityPerSlot = Double.parseDouble(tag.replace("rarityperslot:", ""));
                }
                catch (NumberFormatException e) {
                    rarityPerSlot = 0.15;
                }
                continue;
            }
            if (!tag.startsWith("lootindex:")) continue;
            try {
                lootIndex = Integer.parseInt(tag.replace("lootindex:", ""));
            }
            catch (NumberFormatException e) {
                lootIndex = 0;
            }
        }
        try {
            type = LootDrawer.LootType.valueOf(lootType);
        }
        catch (IllegalArgumentException e) {
            type = LootDrawer.LootType.SUPERFICIE;
        }
        LootDrawer drawer = new LootDrawer(type, lootIndex, rarityPerSlot);
        LootTable.openLootToPlayer(armorStand.getUniqueId(), player, drawer);
    }

    public static enum CHESTS {
        NORMAL_IRON("normal/iron_box"),
        NORMAL_GOLD("normal/gold_box"),
        NORMAL_DIAMOND("normal/diamond_box"),
        NORMAL_AMETHYST("normal/amethyst_box"),
        NORMAL_SPECTER("normal/emerald_box"),
        RARE_IRON("rare/iron_box"),
        RARE_GOLD("rare/gold_box"),
        RARE_DIAMOND("rare/diamond_box"),
        RARE_AMETHYST("rare/amethyst_box"),
        RARE_SPECTER("rare/emerald_box"),
        EPIC_IRON("epic/iron_box"),
        EPIC_GOLD("epic/gold_box"),
        EPIC_DIAMOND("epic/diamond_box"),
        EPIC_AMETHYST("epic/amethyst_box"),
        EPIC_SPECTER("epic/emerald_box"),
        LEGENDARY_IRON("legendary/iron_box"),
        LEGENDARY_GOLD("legendary/gold_box"),
        LEGENDARY_DIAMOND("legendary/diamond_box"),
        LEGENDARY_AMETHYST("legendary/amethyst_box"),
        LEGENDARY_SPECTER("legendary/emerald_box");

        private final String itemModel;

        private CHESTS(String itemModel) {
            this.itemModel = itemModel;
        }

        public String getItemModel() {
            return this.itemModel;
        }
    }
}

