/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.utils;

import me.fixfis.sUHCore.items.SUHItems;
import me.fixfis.sUHCore.utils.Texto;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class OffTopic {
    public static ItemStack getHead(String player) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        head.editMeta(m -> {
            if (m instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)m;
                skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)player));
            }
            m.displayName((Component)Component.text((String)Texto.aColor("&e&l" + player)));
        });
        return head;
    }

    public static Vector calculateBallisticVelocity(Location from, Location to, double gravity, double t) {
        Vector displacement = to.toVector().subtract(from.toVector());
        Vector velocity = new Vector(displacement.getX() / t, displacement.getY() / t + 0.5 * gravity * t, displacement.getZ() / t);
        return velocity;
    }

    public static void applyGlow(Player entity, ChatColor color, String teamName) {
        OffTopic.applyGlow(entity, color, teamName, -1);
    }

    public static void applyGlow(Player entity, ChatColor color, String teamName, int time) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = scoreboard.getTeam(teamName);
        if (team == null) {
            team = scoreboard.registerNewTeam(teamName);
            team.setColor(color);
        }
        team.addPlayer((OfflinePlayer)entity);
        entity.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, time, 1, false, false));
    }

    public static void removeGlow(String teamName) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = scoreboard.getTeam(teamName);
        if (team == null) {
            return;
        }
        team.unregister();
        Bukkit.getOnlinePlayers().forEach(player -> player.removePotionEffect(PotionEffectType.GLOWING));
    }

    public static void blockPlayerSlots(Player player) {
        for (int i = 39; i >= 36; --i) {
            int enumIndex = 39 - i;
            player.getInventory().setItem(i, SUHItems.valueOf("ARMOR_BLOCK" + enumIndex).getItemStack());
        }
    }

    public static int getNearestYawAngle(float yaw) {
        int[] possibleAngles = new int[]{-135, -90, -45, 0, 45, 90, 135, 180};
        int closest = possibleAngles[0];
        float minDiff = OffTopic.getAngleDifference(yaw, closest);
        for (int angle : possibleAngles) {
            float diff = OffTopic.getAngleDifference(yaw, angle);
            if (!(diff < minDiff)) continue;
            minDiff = diff;
            closest = angle;
        }
        return closest;
    }

    private static float getAngleDifference(float a, float b) {
        return Math.abs(((a - b + 180.0f) % 360.0f + 360.0f) % 360.0f - 180.0f);
    }

    public static int getOpsiteYaw(int yaw) {
        return switch (yaw) {
            case -135 -> 45;
            case -90 -> 90;
            case -45 -> 135;
            case 0 -> 180;
            case 45 -> -135;
            case 90 -> -90;
            case 135 -> -45;
            case 180 -> 0;
            default -> throw new IllegalStateException("Unexpected value: " + yaw);
        };
    }
}

