/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.mobs.bosses.moded;

import java.util.List;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.mobs.bosses.FBossEntity;
import me.fixfis.sUHCore.utils.OffTopic;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class LombrizEntity
extends FBossEntity {
    public static List<String> ANIMATIONS = List.of("emerg", "idle", "push", "exit", "diagonal", "linear");

    public LombrizEntity(Location location) {
        super("lombriz", 500, 30, 4, 12, location);
        this.ataqueLinear();
        this.tpAlJugador();
        this.diagonalAttack();
        this.pushAttack();
    }

    @Override
    protected void onBossTarget(Interaction boss, Player entity) {
        OffTopic.applyGlow(entity, ChatColor.RED, this.getKey(), 60);
    }

    void pushAttack() {
        this.addController(new FBossEntity.Controller(){
            Integer attackTime;
            boolean shouldLook = true;

            @Override
            public boolean run(Interaction boss, Player player, Integer currentLivedTime) {
                if (this.attackTime == null) {
                    this.attackTime = currentLivedTime;
                    LombrizEntity.this.playAnimation("push", "hold");
                }
                int tick = currentLivedTime - this.attackTime;
                if (this.shouldLook) {
                    LombrizEntity.this.lookAtTarget((Entity)boss, (Entity)player);
                }
                if (tick == LombrizEntity.this.secondsToTicks(1.21)) {
                    for (int i = 0; i < 6; ++i) {
                        final Interaction in = (Interaction)boss.getWorld().spawn(LombrizEntity.this.getLookLocation(boss.getLocation(), i * 2 + 2), Interaction.class);
                        in.setInteractionWidth(2.0f);
                        in.setInteractionHeight(4.0f);
                        in.getNearbyEntities(2.0, 2.0, 2.0).forEach(e -> {
                            if (e instanceof LivingEntity) {
                                final LivingEntity livingEntity = (LivingEntity)e;
                                LombrizEntity.this.damagePlayer(livingEntity, 8.0);
                                final Vector velocity = boss.getLocation().getDirection().multiply(2).setY(1);
                                new BukkitRunnable(this){

                                    public void run() {
                                        livingEntity.setVelocity(velocity);
                                    }
                                }.runTaskLater((Plugin)SUHCore.instance, 1L);
                            }
                        });
                        new BukkitRunnable(this){

                            public void run() {
                                in.remove();
                            }
                        }.runTaskLater((Plugin)SUHCore.instance, 40L);
                    }
                    return false;
                }
                if (tick == LombrizEntity.this.secondsToTicks(1.5)) {
                    return false;
                }
                if (tick == LombrizEntity.this.secondsToTicks(2.21)) {
                    this.attackTime = null;
                    LombrizEntity.this.playAnimation("idle", "loop");
                    return true;
                }
                return false;
            }
        }, 0, 5);
    }

    void diagonalAttack() {
        this.addController(new FBossEntity.Controller(){
            Integer attackTime;
            boolean shouldLook = true;

            @Override
            public boolean run(Interaction boss, Player player, Integer currentLivedTime) {
                if (this.attackTime == null) {
                    this.attackTime = currentLivedTime;
                    LombrizEntity.this.playAnimation("diagonal", "hold");
                }
                int tick = currentLivedTime - this.attackTime;
                if (this.shouldLook) {
                    LombrizEntity.this.lookAtTarget((Entity)boss, (Entity)player);
                }
                if (tick == LombrizEntity.this.secondsToTicks(1.42)) {
                    this.shouldLook = false;
                    LombrizEntity.this.putEntitySize(18, 4);
                    return false;
                }
                if (tick == LombrizEntity.this.secondsToTicks(2.79)) {
                    boss.getNearbyEntities(5.0, 5.0, 5.0).forEach(e -> {
                        if (e instanceof LivingEntity) {
                            LivingEntity livingEntity = (LivingEntity)e;
                            LombrizEntity.this.damagePlayer(livingEntity, 10.0);
                        }
                    });
                    return false;
                }
                if (tick == LombrizEntity.this.secondsToTicks(3.0)) {
                    this.shouldLook = true;
                    return false;
                }
                if (tick == LombrizEntity.this.secondsToTicks(3.5)) {
                    LombrizEntity.this.playAnimation("idle", "loop");
                    LombrizEntity.this.putDefautlEntitySize();
                    this.shouldLook = false;
                    this.attackTime = null;
                    return true;
                }
                return false;
            }
        }, 5, 10);
    }

    void tpAlJugador() {
        this.addController(new FBossEntity.Controller(){
            Integer attackTime;

            @Override
            public boolean run(Interaction boss, Player player, Integer currentLivedTime) {
                int tick;
                if (this.attackTime == null) {
                    this.attackTime = currentLivedTime;
                    LombrizEntity.this.playAnimation("exit", "hold");
                    LombrizEntity.this.lookAtTarget((Entity)boss, (Entity)player);
                }
                if ((tick = currentLivedTime - this.attackTime) == LombrizEntity.this.secondsToTicks(1.75)) {
                    LombrizEntity.this.putEntitySize(0, 0);
                    return false;
                }
                if (tick == LombrizEntity.this.secondsToTicks(4.0)) {
                    boss.teleport(LombrizEntity.this.ubicacionEntity((Entity)player));
                    LombrizEntity.this.putDefautlEntitySize();
                    boss.getNearbyEntities(4.0, 4.0, 4.0).forEach(e -> {
                        if (e instanceof LivingEntity) {
                            LivingEntity livingEntity = (LivingEntity)e;
                            LombrizEntity.this.damagePlayer(livingEntity, 8.0);
                        }
                    });
                    LombrizEntity.this.playAnimation("emerg", "hold");
                    return false;
                }
                if (tick == LombrizEntity.this.secondsToTicks(6.5)) {
                    LombrizEntity.this.playAnimation("idle", "loop");
                    this.attackTime = null;
                    return true;
                }
                return false;
            }
        }, 14, 100);
    }

    void ataqueLinear() {
        this.addController(new FBossEntity.Controller(){
            Integer attackTime;

            @Override
            public boolean run(Interaction boss, Player player, Integer currentLivedTime) {
                int tick;
                if (this.attackTime == null) {
                    this.attackTime = currentLivedTime;
                    LombrizEntity.this.playAnimation("linear", "hold");
                }
                if ((tick = currentLivedTime - this.attackTime) < LombrizEntity.this.secondsToTicks(1.83)) {
                    LombrizEntity.this.lookAtTarget((Entity)boss, (Entity)player);
                    return false;
                }
                if (tick == LombrizEntity.this.secondsToTicks(1.92)) {
                    LombrizEntity.this.putEntitySize(18, 4);
                    for (int i = 0; i < 6; ++i) {
                        final Interaction in = (Interaction)boss.getWorld().spawn(LombrizEntity.this.getLookLocation(boss.getLocation(), i * 2 + 2), Interaction.class);
                        in.setInteractionWidth(2.0f);
                        in.setInteractionHeight(2.0f);
                        in.getNearbyEntities(2.0, 2.0, 2.0).forEach(e -> {
                            if (e instanceof LivingEntity) {
                                LivingEntity livingEntity = (LivingEntity)e;
                                LombrizEntity.this.damagePlayer(livingEntity, 8.0);
                            }
                        });
                        new BukkitRunnable(this){

                            public void run() {
                                in.remove();
                            }
                        }.runTaskLater((Plugin)SUHCore.instance, 40L);
                    }
                    return false;
                }
                if (tick == LombrizEntity.this.secondsToTicks(3.71)) {
                    LombrizEntity.this.putDefautlEntitySize();
                    LombrizEntity.this.playAnimation("idle", "loop");
                    this.attackTime = null;
                    return true;
                }
                return false;
            }
        }, 5, 14);
    }

    @Override
    protected FBossEntity.SpawnAnimation spawnAnimation() {
        return new FBossEntity.SpawnAnimation("emerg", "idle", 50L);
    }

    @Override
    public List<String> animations() {
        return ANIMATIONS;
    }
}

