/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.grupos.viewer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.fixfis.sUHCore.grupos.SUHGroups;
import me.fixfis.sUHCore.utils.OffTopic;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GroupInv {
    static HashMap<UUID, GroupInv> playerInMenu = new HashMap();
    private final String group;
    private final UUID admin;
    private List<String> users;
    private int page = 0;
    private int maxpage;
    private boolean changingPage = false;

    public static GroupInv getInv(UUID uuid) {
        return playerInMenu.get(uuid);
    }

    public static void openInv(UUID uuid, String group) {
        GroupInv inv = new GroupInv(uuid, group);
        playerInMenu.put(uuid, inv);
        Bukkit.getPlayer((UUID)uuid).openInventory(inv.generateInv());
    }

    public GroupInv(UUID admin, String group) {
        this.group = group;
        this.admin = admin;
        this.generateData();
    }

    public void onClose() {
        if (!this.changingPage) {
            playerInMenu.remove(this.admin);
        } else {
            this.changingPage = false;
        }
    }

    public void onSelectEvent(InventoryClickEvent event) {
        event.setCancelled(true);
        if (Objects.equals(event.getClickedInventory(), Bukkit.getPlayer((UUID)this.admin).getOpenInventory().getTopInventory())) {
            if (event.getSlot() == 45) {
                this.prevPage();
            } else if (event.getSlot() == 53) {
                this.nextPage();
            }
        }
    }

    public void onUserClick(OfflinePlayer offlinePlayer, boolean isLeftClick) {
    }

    void nextPage() {
        if (this.page + 1 < this.maxpage) {
            ++this.page;
            this.changingPage = true;
            Bukkit.getPlayer((UUID)this.admin).openInventory(this.generateInv());
        }
    }

    void prevPage() {
        if (this.page - 1 >= 0) {
            --this.page;
            this.changingPage = true;
            Bukkit.getPlayer((UUID)this.admin).openInventory(this.generateInv());
        }
    }

    void generateData() {
        if (this.group.equalsIgnoreCase("@all@")) {
            this.users = Arrays.stream(Bukkit.getOfflinePlayers()).map(OfflinePlayer::getName).toList();
            this.maxpage = this.users.size() % 45 == 0 ? this.users.size() / 45 : this.users.size() / 45 + 1;
            return;
        }
        this.users = SUHGroups.getUsersInGroup(this.group);
        this.maxpage = this.users.size() % 45 == 0 ? this.users.size() / 45 : this.users.size() / 45 + 1;
    }

    private Inventory generateInv() {
        int slot;
        Inventory inv = Bukkit.createInventory(null, (int)54, (Component)Component.text((String)this.group));
        this.generateData();
        for (int i = slot = this.page * 45; i < this.users.size() && slot != (this.page + 1) * 45; ++slot, ++i) {
            String user = this.users.get(i);
            ItemStack skull = OffTopic.getHead(user);
            int finalSlot = slot;
            skull.editMeta(m -> m.displayName((Component)Component.text((String)(user + " " + finalSlot))));
            inv.setItem(slot - this.page * 45, skull);
        }
        if (this.page + 1 != this.maxpage) {
            inv.setItem(53, new ItemStack(Material.GREEN_WOOL));
        }
        if (this.page - 1 >= 0) {
            inv.setItem(45, new ItemStack(Material.GREEN_WOOL));
        }
        return inv;
    }
}

