/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.lootable;

import java.util.List;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.lootable.LootDrops;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public record LootDrawer(LootType lootType, int lootTypeIndex, double rarityPerSlot) {
    public void openInv(Player player) {
        player.openInventory(this.lootInv());
    }

    private Inventory lootInv() {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)this.lootType.getName());
        for (int i = 0; i < inv.getSize(); ++i) {
            if (!(SUHCore.random.nextDouble() < this.rarityPerSlot)) continue;
            LootDrops selectedLoot = this.lootType.getLoots().get(this.lootTypeIndex);
            ItemStack item = selectedLoot.getLoot(SUHCore.random);
            inv.setItem(i, item);
        }
        return inv;
    }

    @Override
    public String toString() {
        return "LootDrawer{lootType=" + String.valueOf((Object)this.lootType) + ", lootTypeIndex=" + this.lootTypeIndex + ", rarityPerSlot=" + this.rarityPerSlot + "}";
    }

    public static enum LootType {
        SUPERFICIE(List.of(LootDrops.kknero_superficie), "\ue000"),
        ABAJO(List.of(LootDrops.kknero_submundo), "\ue000\ue000"),
        IRON(List.of(LootDrops.ironLoot), "\ue000\ue000\ue000"),
        NETHER(List.of(), "\ue000\ue000\ue000\ue000"),
        GOLD(List.of(), "\ue000\ue000\ue000\ue000\ue000"),
        DIAMOND(List.of(), "\ue000\ue000\ue000\ue000\ue000\ue000");

        private final List<LootDrops> loots;
        private final String name;

        private LootType(List<LootDrops> loots, String name) {
            this.loots = loots;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<LootDrops> getLoots() {
            return this.loots;
        }
    }
}

