/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.muertes.interfaz;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.fixfis.sUHCore.items.SUHItems;
import me.fixfis.sUHCore.mobs.SUHMobs;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FEntity;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FInteraction;
import me.fixfis.sUHCore.muertes.Muertos;
import me.fixfis.sUHCore.muertes.Revivir;
import me.fixfis.sUHCore.muertes.interfaz.inv.InventoryContainer;
import me.fixfis.sUHCore.muertes.interfaz.inv.InventoryFrame;
import me.fixfis.sUHCore.utils.Texto;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class RevivirIntefaz {
    public static List<InventoryContainer> playersThatHasOpenAnInventory = new ArrayList<InventoryContainer>();
    private final Player player;
    private int frame = 0;
    private final InventoryContainer inventoryContainer;
    private UUID currentUUid;
    private final Interaction portal;

    public static void deletoFrom(Player player) {
        playersThatHasOpenAnInventory.removeIf(inventoryContainer -> inventoryContainer.getPlayer().getUniqueId().equals(player.getUniqueId()));
    }

    public static RevivirIntefaz isInList(Player player) {
        for (InventoryContainer inventoryContainer : playersThatHasOpenAnInventory) {
            if (!inventoryContainer.getPlayer().getUniqueId().equals(player.getUniqueId())) continue;
            return inventoryContainer.getRevivirIntefaz();
        }
        return null;
    }

    public RevivirIntefaz(Player player, Interaction portal) {
        this.player = player;
        this.portal = portal;
        this.inventoryContainer = new InventoryContainer(player, this);
        this.openInventory();
    }

    public void onSelectEvent(InventoryClickEvent event) {
        event.setCancelled(true);
        if (Objects.equals(event.getClickedInventory(), this.player.getOpenInventory().getTopInventory())) {
            if (event.getSlot() == 19) {
                this.onLeft();
            } else if (event.getSlot() == 25) {
                this.onRight();
            } else if (event.getSlot() == 22) {
                this.onDone();
            }
        }
    }

    final void onDirection() {
        this.player.playSound((Entity)this.player, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        this.openInventory();
    }

    void add() {
        if (!playersThatHasOpenAnInventory.contains(this.inventoryContainer)) {
            playersThatHasOpenAnInventory.add(this.inventoryContainer);
        }
    }

    void openInventory() {
        if (Muertos.muertos.isEmpty()) {
            return;
        }
        this.currentUUid = Muertos.muertos.get(this.frame);
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)this.currentUUid);
        String playerName = offlinePlayer.getName() != null ? offlinePlayer.getName() : "Unknown";
        InventoryFrame inv = new InventoryFrame(playerName);
        this.player.openInventory(inv.inventory());
        this.add();
    }

    void closeInventory() {
        playersThatHasOpenAnInventory.remove(this.inventoryContainer);
        this.player.closeInventory();
    }

    void onLeft() {
        this.frame = this.frame > 0 ? this.frame - 1 : Muertos.muertos.size() - 1;
        this.onDirection();
    }

    void onRight() {
        this.frame = this.frame < Muertos.muertos.size() - 1 ? this.frame + 1 : 0;
        this.onDirection();
    }

    void onDone() {
        if (SUHItems.UTILS_MEDALLON_REVIVIR.hasPlayerThisItem(this.player, 1)) {
            this.onDirection();
            Revivir.revivirNoConectado(this.currentUUid);
            FEntity<? extends Entity> fEntity = SUHMobs.SUH_PORTAL.getfEntity();
            if (fEntity instanceof FInteraction) {
                FInteraction i = (FInteraction)fEntity;
                i.playAnimation("revive", this.portal, "hold").speakToNearesPlayers("&cAlgo se est\u00e1 liberando...").then(180, "loop", "idle");
            }
        } else {
            this.onDirection();
            this.player.sendMessage(Texto.aColor("&cNo tienes un medallon para revivir"));
        }
        this.closeInventory();
    }
}

