/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import me.fixfis.InitServer;
import me.fixfis.sUHCore.config.SUHGenericConfig;
import me.fixfis.sUHCore.events.SUHEvents;
import me.fixfis.sUHCore.grupos.SUHGroups;
import me.fixfis.sUHCore.items.SUHItems;
import me.fixfis.sUHCore.items.modItems.newItems.FItemTotem;
import me.fixfis.sUHCore.lootable.LootTable;
import me.fixfis.sUHCore.minijuegos.Minijuegos;
import me.fixfis.sUHCore.mobs.SUHMobs;
import me.fixfis.sUHCore.mobs.bosses.BossEntityConfig;
import me.fixfis.sUHCore.mobs.bosses.FBossEntity;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FEntity;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FInteraction;
import me.fixfis.sUHCore.muertes.Muertos;
import me.fixfis.sUHCore.muertes.Revivir;
import me.fixfis.sUHCore.sever_client.ClientUtils;
import me.fixfis.sUHCore.specialEvents.insomio.InsomnioBar;
import me.fixfis.sUHCore.stuff.FCOMMANDS;
import me.fixfis.sUHCore.stuff.FLISTENER;
import me.fixfis.sUHCore.stuff.FTABCOMPLETER;
import me.fixfis.sUHCore.stuff.Helpop;
import me.fixfis.sUHCore.tps.SUHTps;
import me.fixfis.sUHCore.utils.TemporaryAttributeManager;
import me.fixfis.sUHCore.utils.Texto;
import me.fixfis.sUHCore.utils.config.FFileManager;
import me.fixfis.sUHCore.utils.logger.FLogger;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.JSONObject;

public final class SUHCore
extends JavaPlugin {
    public static final Random random = new Random();
    private final int idPlugin = 15;
    public static SUHCore instance;
    public static FFileManager fileManager;
    private InitServer initServer;
    public static JSONObject FILErevividos;
    public static JSONObject FILEmuertes;
    public static JSONObject FILEcraftings;
    public static JSONObject FILEmobs;
    public static JSONObject FILEevents;
    public static JSONObject FILEgenericconfig;
    public static JSONObject FILElootable;
    public static JSONObject FILEminijuegos;
    public static JSONObject FILEtokens;
    public static JSONObject FILEitems;
    public static JSONObject FILEboss;
    public static JSONObject FILEgroups;
    public static JSONObject FILEinteractionsEntities;
    public static JSONObject FILEtps;
    public static Set<UUID> playersInL4D;
    public static Set<UUID> notifiedPlayers;
    private final List<UUID> playersInRain = new ArrayList<UUID>();
    public static Map<String, TaskSender> taskSenders;

    public void onEnable() {
        fileManager = new FFileManager(String.valueOf(this.getDataFolder()) + "/");
        instance = this;
        this.initServer = new InitServer(15, this, "suhcore", true);
        InitServer.setLocal(true);
        if (this.initServer.getEstadoDeLicencia()) {
            FILEcraftings = fileManager.load(FFileManager.FILE.CRAFTING);
            FILEmobs = fileManager.load(FFileManager.FILE.MOBSFILE);
            FILEevents = fileManager.load(FFileManager.FILE.EVENTS_CONFIG);
            FILEgenericconfig = fileManager.load(FFileManager.FILE.GENERIC_CONFIG);
            FILEmuertes = fileManager.load(FFileManager.FILE.MUERTES_USERS);
            FILErevividos = fileManager.load(FFileManager.FILE.REVIVIDOS_USERS);
            FILElootable = fileManager.load(FFileManager.FILE.LOOTABLES);
            FILEminijuegos = fileManager.load(FFileManager.FILE.MINIJUEGOS);
            FILEtokens = fileManager.load(FFileManager.FILE.USUARIOS_TOKENS);
            FILEitems = fileManager.load(FFileManager.FILE.ITEMS);
            FILEboss = fileManager.load(FFileManager.FILE.BOSSFILE);
            FILEgroups = fileManager.load(FFileManager.FILE.GROUPS);
            FILEinteractionsEntities = fileManager.load(FFileManager.FILE.FINTERACTIONS);
            FILEtps = fileManager.load(FFileManager.FILE.LUGARES);
            this.runeable();
            this.runeable2();
            this.initCommands();
            this.initSUHCore();
            FLogger.debugging("Plugin enabled!");
        }
    }

    public void onDisable() {
        if (this.initServer.getEstadoDeLicencia()) {
            this.disableSUHCore();
            fileManager.save(FILEtps, FFileManager.FILE.LUGARES);
            fileManager.save(FILEinteractionsEntities, FFileManager.FILE.FINTERACTIONS);
            fileManager.save(FILEgroups, FFileManager.FILE.GROUPS);
            fileManager.save(FILEboss, FFileManager.FILE.BOSSFILE);
            fileManager.save(FILEitems, FFileManager.FILE.ITEMS);
            fileManager.save(FILEtokens, FFileManager.FILE.USUARIOS_TOKENS);
            fileManager.save(FILEminijuegos, FFileManager.FILE.MINIJUEGOS);
            fileManager.save(FILElootable, FFileManager.FILE.LOOTABLES);
            fileManager.save(FILErevividos, FFileManager.FILE.REVIVIDOS_USERS);
            fileManager.save(FILEmuertes, FFileManager.FILE.MUERTES_USERS);
            fileManager.save(FILEcraftings, FFileManager.FILE.CRAFTING);
            fileManager.save(FILEmobs, FFileManager.FILE.MOBSFILE);
            fileManager.save(FILEevents, FFileManager.FILE.EVENTS_CONFIG);
            fileManager.save(FILEgenericconfig, FFileManager.FILE.GENERIC_CONFIG);
            fileManager.save(FILElootable, FFileManager.FILE.LOOTABLES);
            FLogger.debugging("Plugin disabled!");
            for (SUHItems value : SUHItems.values()) {
                NamespacedKey craftKey;
                if (!value.item.isCraftable() || !Bukkit.removeRecipe((NamespacedKey)(craftKey = new NamespacedKey("fcraft", value.item.getKey())))) continue;
                FLogger.info("Receta " + value.item.getKey() + " eliminada!");
            }
        }
    }

    void initCommands() {
        ClientUtils cliente = new ClientUtils();
        this.getCommand("suhcore").setExecutor((CommandExecutor)new FCOMMANDS());
        this.getCommand("suhf66").setExecutor((CommandExecutor)cliente);
        this.getCommand("suhcore").setTabCompleter((TabCompleter)new FTABCOMPLETER());
        this.getCommand("helpop").setExecutor((CommandExecutor)new Helpop());
        this.getServer().getPluginManager().registerEvents((Listener)new FLISTENER(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TemporaryAttributeManager(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)cliente, (Plugin)this);
    }

    void initSUHCore() {
        FItemTotem.load();
        SUHItems.values();
        SUHMobs.values();
        SUHMobs.values();
        SUHGroups.load();
        BossEntityConfig.load();
        LootTable.load();
        Muertos.load();
        Revivir.load();
        ClientUtils.loadOps();
        FBossEntity.initBossesClasses();
        FBossEntity.initBossesAnimations();
        SUHTps.load();
        for (SUHEvents sUHEvents : SUHEvents.values()) {
            sUHEvents.getCrearEvento().load();
        }
        for (Enum enum_ : SUHGenericConfig.values()) {
            ((SUHGenericConfig)enum_).getConfig().load();
        }
        for (Enum enum_ : SUHMobs.values()) {
            FEntity<? extends Entity> fEntity = ((SUHMobs)enum_).getfEntity();
            if (!(fEntity instanceof FInteraction)) continue;
            FInteraction fi = (FInteraction)fEntity;
            fi.load();
        }
    }

    void disableSUHCore() {
        Bukkit.getOnlinePlayers().forEach(p -> p.setOp(false));
        FItemTotem.save();
        for (SUHMobs sUHMobs : SUHMobs.values()) {
            FEntity<? extends Entity> fEntity = sUHMobs.getfEntity();
            if (!(fEntity instanceof FInteraction)) continue;
            FInteraction fi = (FInteraction)fEntity;
            fi.save();
        }
        if (FCOMMANDS.hasinitedMinigames) {
            for (Enum enum_ : Minijuegos.values()) {
                ((Minijuegos)enum_).getBase().save();
            }
        }
        for (Enum enum_ : SUHEvents.values()) {
            ((SUHEvents)enum_).getCrearEvento().save();
        }
        for (Enum enum_ : SUHGenericConfig.values()) {
            ((SUHGenericConfig)enum_).getConfig().save();
        }
        for (Enum enum_ : SUHMobs.values()) {
            ((SUHMobs)enum_).saveData();
        }
        for (Enum enum_ : SUHMobs.values()) {
            ((SUHMobs)enum_).saveData();
        }
        Muertos.save();
        Revivir.save();
        LootTable.save();
        TemporaryAttributeManager.removeAllBuffs();
        BossEntityConfig.save();
        SUHGroups.save();
        ClientUtils.saveOps();
        SUHTps.save();
    }

    void runeable() {
        new BukkitRunnable(){

            public void run() {
                if (SUHEvents.INSOMNIO.isEnabled()) {
                    Bukkit.getOnlinePlayers().forEach(p -> {
                        SUHCore.this.onAcidRain((Player)p);
                        InsomnioBar.shouldSleep(p);
                    });
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    void runeable2() {
        new BukkitRunnable(this){

            public void run() {
                if (SUHEvents.L4D_SPAWN_RATE.isEnabled()) {
                    playersInL4D.clear();
                    HashSet temPlayers = new HashSet();
                    Bukkit.getOnlinePlayers().forEach(p -> {
                        int radio = (Integer)SUHGenericConfig.RADIO_TO_L4D_EVENT.getValue();
                        for (Entity nearbyEntity : p.getNearbyEntities((double)radio, (double)radio, (double)radio)) {
                            Player player;
                            if (!(nearbyEntity instanceof Player) || (player = (Player)nearbyEntity).getGameMode() != GameMode.SURVIVAL) continue;
                            temPlayers.add(player.getUniqueId());
                        }
                        if (temPlayers.size() >= (Integer)SUHGenericConfig.AMOUNT_OF_PLAYERS_TO_L4D_EVENT.getValue() + 1) {
                            playersInL4D.addAll(temPlayers);
                        }
                        temPlayers.clear();
                    });
                    for (UUID u : playersInL4D) {
                        if (notifiedPlayers.contains(u)) continue;
                        Player p2 = Bukkit.getPlayer((UUID)u);
                        if (p2 != null) {
                            p2.sendMessage(Texto.aColor("&4Algo esta pasando... creo que somos muchos..."));
                        }
                        notifiedPlayers.add(u);
                    }
                    notifiedPlayers.retainAll(playersInL4D);
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 200L);
    }

    public void onAcidRain(final Player player) {
        if (SUHEvents.ACID_RAIN.isEnabled()) {
            if (this.playersInRain.contains(player.getUniqueId())) {
                return;
            }
            if (player.isInRain() && !player.isDead() && player.getGameMode() == GameMode.SURVIVAL) {
                this.playersInRain.add(player.getUniqueId());
                new BukkitRunnable(){

                    public void run() {
                        if (!player.isOnline() || player.isDead() || player.getGameMode() != GameMode.SURVIVAL || !player.isInRain() || !SUHEvents.ACID_RAIN.isEnabled() || SUHItems.UTILS_UMBRELLA.isThisItem(player.getInventory().getItemInMainHand()) || SUHItems.UTILS_UMBRELLA.isThisItem(player.getInventory().getItemInOffHand()) || SUHItems.UTILS_UMBRELLA_HAT.isThisItem(player.getInventory().getHelmet())) {
                            SUHCore.this.playersInRain.remove(player.getUniqueId());
                            this.cancel();
                            return;
                        }
                        player.damage(Double.parseDouble(SUHGenericConfig.ACIDRAINDAMAGE.getValue().toString()));
                        player.sendHurtAnimation(1.0f);
                    }
                }.runTaskTimer((Plugin)instance, 0L, 20L);
            }
        }
    }

    public static void fTaskSender(String name, TaskSender taskSender) {
        taskSenders.put(name, taskSender);
    }

    public FFileManager getFileManager() {
        return fileManager;
    }

    static {
        playersInL4D = new HashSet<UUID>();
        notifiedPlayers = new HashSet<UUID>();
        taskSenders = new HashMap<String, TaskSender>();
    }

    @FunctionalInterface
    public static interface TaskSender {
        public void run(Entity[] var1, String[] var2);
    }
}

