/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.minijuegos;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.minijuegos.MiniJuegoBase;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FEntity;
import me.fixfis.sUHCore.utils.OffTopic;
import me.fixfis.sUHCore.utils.logger.FLogger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Shulker;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

public class Mingle
extends MiniJuegoBase {
    private static World world;
    private final HashMap<BlockDisplay, Location> hashMap = new HashMap();
    private final HashMap<Location, BlockData> hashMapLocBlock = new HashMap();
    private final List<BlockDisplay> displays = new ArrayList<BlockDisplay>();
    private Entity armStand = null;
    Location center;
    private final List<Door> doors = new ArrayList<Door>();
    Set<UUID> validedDoors = new HashSet<UUID>();
    private final Set<UUID> clickedEntityes = new HashSet<UUID>();

    public Mingle(World world, String keyName) {
        super(world, keyName);
        Mingle.world = world;
        if (!this.jsonMinigame.has("center")) {
            JSONObject center = new JSONObject();
            center.put("world", world.getName());
            center.put("x", 0);
            center.put("y", 100);
            center.put("z", 0);
            center.put("radio", 0);
            this.center = new Location(world, center.getDouble("x"), center.getDouble("y"), center.getDouble("z"), 0.0f, 0.0f);
            this.jsonMinigame.put("center", center);
        } else {
            JSONObject loc = this.jsonMinigame.getJSONObject("center");
            this.center = new Location(Bukkit.getWorld((String)loc.getString("world")), loc.getDouble("x"), loc.getDouble("y"), loc.getDouble("z"), 0.0f, 0.0f);
        }
        if (!this.jsonMinigame.has("doors")) {
            this.jsonMinigame.put("doors", new JSONArray());
        } else {
            JSONArray doors = this.jsonMinigame.getJSONArray("doors");
            for (Object obj : doors) {
                if (!(obj instanceof JSONObject)) continue;
                JSONObject door = (JSONObject)obj;
                JSONObject coll = door.getJSONObject("collision");
                Collision collision = new Collision(UUID.fromString(coll.getString("a")), UUID.fromString(coll.getString("s")));
                JSONObject l = door.getJSONObject("luz");
                Luz luz = new Luz(l.getInt("x"), l.getInt("y"), l.getInt("z"), l.getBoolean("light"));
                Door d = new Door(UUID.fromString(door.getString("axis")), UUID.fromString(door.getString("hitbox")), luz, collision, door.getInt("yaw"), door.getBoolean("locked"), door.getBoolean("opened"));
                this.doors.add(d);
            }
            FLogger.debugging("mngle doors cargados: " + this.doors.size());
        }
    }

    @Override
    protected void comando(@NotNull Player commandSender, @NotNull String[] strings) {
        if (commandSender == null) {
            Mingle.$$$reportNull$$$0(0);
        }
        if (strings == null) {
            Mingle.$$$reportNull$$$0(1);
        }
        switch (strings[0]) {
            case "setCenter": {
                this.setMingleCenter(commandSender, strings);
                break;
            }
            case "transformar": {
                this.transformar();
                break;
            }
            case "summonDoor": {
                this.summnoDoor(commandSender, strings);
                break;
            }
            case "rotar": {
                if (strings.length < 3) break;
                int vueltas = Integer.parseInt(strings[1]);
                int segundos = Integer.parseInt(strings[2]);
                this.rotarEstructura(vueltas, segundos, strings);
                break;
            }
            case "reset": {
                this.reset(strings);
                break;
            }
            case "info": {
                this.getinfo(Integer.parseInt(strings[1]));
                break;
            }
            case "cerrarTodo": {
                this.cerrarTodo();
                break;
            }
            case "abrirTodo": {
                this.abrirTodo();
                break;
            }
            case "doorCommand": {
                this.seleccionarPuerta(Integer.parseInt(strings[1]), Boolean.parseBoolean(strings[2]));
                break;
            }
            case "luz": {
                this.luz(strings[1].equalsIgnoreCase("on"));
            }
        }
    }

    @Override
    protected List<String> tabCompleter(List<String> args, String[] strings, Player p) {
        block29: {
            block0 : switch (strings.length) {
                case 1: {
                    args.addAll(List.of("setCenter", "transformar", "summonDoor", "rotar", "reset", "info", "cerrarTodo", "abrirTodo", "doorCommand", "luz"));
                    break;
                }
                case 2: {
                    switch (strings[0]) {
                        case "selDoor": 
                        case "info": {
                            for (int i = 0; i < this.doors.size(); ++i) {
                                args.add("" + i);
                            }
                            break block0;
                        }
                        case "summonDoor": {
                            Block b = p.getTargetBlock(null, 4);
                            args.add(b.getX() + " " + b.getY() + " " + b.getZ());
                            break;
                        }
                        case "luz": {
                            args.addAll(List.of("on", "off"));
                            break;
                        }
                        case "rotar": {
                            for (int i = 0; i < 50; ++i) {
                                args.add("" + i);
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    switch (strings[0]) {
                        case "rotar": {
                            for (int i = 0; i < 50; ++i) {
                                args.add("" + i);
                            }
                            break block29;
                        }
                        case "selDoor": {
                            args.addAll(List.of("true", "false"));
                        }
                    }
                }
            }
        }
        return args;
    }

    void getinfo(int index) {
        Door door = this.doors.get(index);
        FLogger.debugging(door.toString());
    }

    void cerrarTodo() {
        for (Door door : this.doors) {
            if (door.locked) continue;
            door.setLocked(false);
            this.cerrarPuerta(door, false);
        }
    }

    void abrirTodo() {
        for (Door door : this.doors) {
            if (!door.locked) continue;
            this.abrirPuerta(door);
        }
    }

    void seleccionarPuerta(int index, boolean v) {
        Door door = this.doors.get(index);
        if (v) {
            if (!door.locked) {
                return;
            }
            this.validedDoors.add(door.hitbox);
            this.abrirPuerta(door);
        } else {
            if (door.locked) {
                return;
            }
            door.setLocked(false);
            this.cerrarPuerta(door, true);
        }
    }

    void abrirPuerta(Door door) {
        door.luz.setLight(true);
        door.setLocked(false);
        door.luz.convertBlock();
        this.openNaNoor(door, null, false);
    }

    void cerrarPuerta(Door door, boolean turnOffLight) {
        if (door.locked) {
            return;
        }
        if (turnOffLight) {
            door.luz.setLight(false);
            door.luz.convertBlock();
        }
        this.openNaNoor(door, null, false);
        door.setLocked(true);
    }

    private Door getDoorFromHitbox(UUID u) {
        for (Door door : this.doors) {
            if (!door.hitbox.equals(u) && !door.collision.shulker.equals(u)) continue;
            return door;
        }
        return null;
    }

    @EventHandler
    public final void onRigthClick(PlayerInteractAtEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (entity instanceof ArmorStand) {
            ArmorStand st = (ArmorStand)entity;
            if (st.getScoreboardTags().contains("hitbox") && this.validedDoors.contains(st.getUniqueId())) {
                door = this.getDoorFromHitbox(st.getUniqueId());
                if (door == null) {
                    return;
                }
                this.validedDoors.remove(st.getUniqueId());
                this.cerrarPuerta(door, true);
            }
        } else if (event.getRightClicked().getScoreboardTags().contains("mgshulker") && event.getPlayer().getInventory().getItemInMainHand().getType() == Material.TARGET && event.getPlayer().hasPermission("asa")) {
            door = this.getDoorFromHitbox(event.getRightClicked().getUniqueId());
            if (door == null) {
                return;
            }
            this.removeDoor(door);
        }
    }

    void removeDoor(Door door) {
        this.doors.remove(door);
        world.getEntity(door.axis).remove();
        world.getEntity(door.collision.stand).remove();
        world.getEntity(door.collision.shulker).remove();
    }

    void openNaNoor(final Door door, Player pLAYER, final boolean bol) {
        int modifiquer;
        double[] dArray;
        ItemStack hand;
        if (this.clickedEntityes.contains(door.hitbox)) {
            return;
        }
        if (pLAYER != null && (hand = pLAYER.getInventory().getItemInMainHand()).getType() == Material.TARGET && pLAYER.hasPermission("asa")) {
            this.clickedEntityes.remove(door.hitbox);
            this.removeDoor(door);
            return;
        }
        if (door.locked) {
            Bukkit.getOnlinePlayers().forEach(py -> py.playSound(py.getLocation(), "doors.force", SoundCategory.PLAYERS, 2.0f, 1.0f));
            return;
        }
        this.clickedEntityes.add(door.hitbox);
        final int frames = 10;
        int intervalo = 1;
        FLogger.info("valido");
        int ticksTotales = frames * intervalo;
        double desplazamientoportick = 2.0 / (double)ticksTotales;
        final double yawpertick = 90.0 / (double)ticksTotales;
        switch (door.yaw) {
            case 0: {
                double[] dArray2 = new double[4];
                dArray2[0] = 0.0;
                dArray2[1] = desplazamientoportick / 2.0;
                dArray2[2] = desplazamientoportick / 2.0;
                dArray = dArray2;
                dArray2[3] = 0.0;
                break;
            }
            case 90: {
                double[] dArray3 = new double[4];
                dArray3[0] = -desplazamientoportick / 2.0;
                dArray3[1] = 0.0;
                dArray3[2] = 0.0;
                dArray = dArray3;
                dArray3[3] = desplazamientoportick / 2.0;
                break;
            }
            case 180: {
                double[] dArray4 = new double[4];
                dArray4[0] = 0.0;
                dArray4[1] = -desplazamientoportick / 2.0;
                dArray4[2] = -desplazamientoportick / 2.0;
                dArray = dArray4;
                dArray4[3] = 0.0;
                break;
            }
            case -90: {
                double[] dArray5 = new double[4];
                dArray5[0] = desplazamientoportick / 2.0;
                dArray5[1] = 0.0;
                dArray5[2] = 0.0;
                dArray = dArray5;
                dArray5[3] = -desplazamientoportick / 2.0;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + door.yaw);
            }
        }
        final double[] dorMovment = dArray;
        final ArmorStand axis = (ArmorStand)world.getEntity(door.axis);
        final ArmorStand carry = (ArmorStand)world.getEntity(door.collision.stand);
        final Shulker colShulker = (Shulker)world.getEntity(door.collision.shulker);
        if (axis == null || carry == null || colShulker == null) {
            this.doors.remove(door);
            FLogger.warning("puerta corrupta eliminada");
            return;
        }
        if (door.opened) {
            Bukkit.getOnlinePlayers().forEach(py -> py.playSound(axis.getLocation(), "doors.open", SoundCategory.PLAYERS, 2.0f, 1.0f));
            modifiquer = 1;
        } else {
            Bukkit.getOnlinePlayers().forEach(py -> py.playSound(axis.getLocation(), "doors.close", SoundCategory.PLAYERS, 2.0f, 1.0f));
            modifiquer = -1;
        }
        door.setOpened(!door.opened);
        door.locked = false;
        final int finalModifiquer = modifiquer;
        new BukkitRunnable(){
            int i = 0;

            public void run() {
                if (this.i++ >= frames) {
                    FLogger.info("cancelado");
                    Mingle.this.clickedEntityes.remove(door.hitbox);
                    this.cancel();
                    if (bol) {
                        new BukkitRunnable(){

                            public void run() {
                                Mingle.this.openNaNoor(door, null, false);
                            }
                        }.runTaskLater((Plugin)SUHCore.instance, 40L);
                    }
                    return;
                }
                Location temp = axis.getLocation().clone();
                temp.setYaw((float)((double)axis.getLocation().getYaw() - yawpertick * (double)finalModifiquer));
                axis.teleport(temp);
                carry.removePassenger((Entity)colShulker);
                temp = carry.getLocation().clone();
                temp.setX(temp.getX() + dorMovment[2] * (double)finalModifiquer);
                temp.setZ(temp.getZ() + dorMovment[3] * (double)finalModifiquer);
                carry.teleport(temp);
                carry.addPassenger((Entity)colShulker);
            }
        }.runTaskTimer((Plugin)SUHCore.instance, 0L, (long)intervalo);
    }

    void summnoDoor(Player p, String[] s) {
        double[] dArray;
        Block block = p.getWorld().getBlockAt(new Location(p.getWorld(), (double)Integer.parseInt(s[1]), (double)Integer.parseInt(s[2]), (double)Integer.parseInt(s[3])));
        Location location = p.getLocation().clone();
        location.setX((double)location.getBlockX() + 0.5);
        location.setY((double)location.getBlockY());
        location.setZ((double)location.getBlockZ() + 0.5);
        int yaw = OffTopic.getNearestYawAngle(location.getYaw());
        location.setYaw((float)yaw);
        location.setPitch(0.0f);
        ArmorStand carry = (ArmorStand)location.getWorld().spawn(location.clone().add(0.0, -0.4, 0.0), ArmorStand.class);
        carry.setSmall(true);
        this.putStuffToAS(carry, "mgmove");
        ArmorStand hitbox = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
        this.putStuffToAS(hitbox, "hitbox");
        switch (yaw) {
            case 0: {
                double[] dArray2 = new double[2];
                dArray2[0] = -0.5;
                dArray = dArray2;
                dArray2[1] = 0.0;
                break;
            }
            case 90: {
                double[] dArray3 = new double[2];
                dArray3[0] = 0.0;
                dArray = dArray3;
                dArray3[1] = -0.5;
                break;
            }
            case 180: {
                double[] dArray4 = new double[2];
                dArray4[0] = 0.49;
                dArray = dArray4;
                dArray4[1] = 0.0;
                break;
            }
            case -90: {
                double[] dArray5 = new double[2];
                dArray5[0] = 0.0;
                dArray = dArray5;
                dArray5[1] = 0.49;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + yaw);
            }
        }
        double[] doorlocation = dArray;
        ArmorStand door = (ArmorStand)location.getWorld().spawn(location.clone().add(doorlocation[0], 0.0, doorlocation[1]), ArmorStand.class);
        this.putStuffToAS(door, "mgdoor");
        door.getEquipment().setHelmet(FEntity.getItemstackWhitItemModel(Material.STICK, "mgdoor"));
        Shulker shulker = (Shulker)location.getWorld().spawn(location, Shulker.class);
        shulker.setGravity(false);
        shulker.setInvulnerable(true);
        shulker.setAI(false);
        shulker.setSilent(true);
        shulker.setInvisible(true);
        shulker.getScoreboardTags().add("mgdoor");
        shulker.getScoreboardTags().add("mgshulker");
        Collision collision = new Collision(carry.getUniqueId(), shulker.getUniqueId());
        Door doorObject = new Door(door.getUniqueId(), hitbox.getUniqueId(), new Luz(block.getX(), block.getY(), block.getZ(), true), collision, yaw, true, false);
        FLogger.debugging("entidad generada en " + location.getWorld().getName() + " -> " + String.valueOf(doorObject));
        this.doors.add(doorObject);
        carry.addPassenger((Entity)shulker);
    }

    void putStuffToAS(ArmorStand stand, String id) {
        stand.addDisabledSlots(new EquipmentSlot[]{EquipmentSlot.HEAD});
        stand.addDisabledSlots(new EquipmentSlot[]{EquipmentSlot.CHEST});
        stand.addDisabledSlots(new EquipmentSlot[]{EquipmentSlot.LEGS});
        stand.addDisabledSlots(new EquipmentSlot[]{EquipmentSlot.FEET});
        stand.setGravity(false);
        stand.setBasePlate(false);
        stand.setArms(false);
        stand.setInvisible(true);
        stand.setInvulnerable(true);
        stand.getScoreboardTags().add(id);
        stand.getScoreboardTags().add("mgdoor");
    }

    private void addHashMap(BlockDisplay display) {
        this.hashMap.put(display, display.getLocation());
    }

    private void delHashMap(BlockDisplay display) {
        this.hashMap.remove(display);
    }

    private Location getHashMap(BlockDisplay display) {
        return this.hashMap.getOrDefault(display, null);
    }

    private void locBlockaddHashMap(Location location, BlockData data) {
        this.hashMapLocBlock.put(location, data);
        FLogger.info("guardado " + String.valueOf(data));
    }

    private void locBlockdelHashMap(Location location) {
        this.hashMapLocBlock.remove(location);
        FLogger.info("removido loc ");
    }

    private BlockData locBlockgetHashMap(Location location) {
        FLogger.info("dando " + String.valueOf(this.hashMapLocBlock.getOrDefault(location, location.getBlock().getBlockData())));
        return this.hashMapLocBlock.getOrDefault(location, location.getBlock().getBlockData());
    }

    private void luz(final boolean turn) {
        Location loc = this.center.clone();
        int baseRadius = (int)this.jsonMinigame.getJSONObject("center").getDouble("radio");
        int span = baseRadius * 2;
        final Location start = new Location(loc.getWorld(), (double)(loc.getBlockX() - span), (double)loc.getBlockY(), (double)(loc.getBlockZ() - span), 0.0f, 0.0f);
        final int max = span * 2;
        int BLOCKS_PER_TICK = 40000;
        new BukkitRunnable(this){
            int x = 0;
            int y = 0;
            int z = 0;

            public void run() {
                for (int processed = 0; processed < 40000; ++processed) {
                    if (this.y > max) {
                        this.cancel();
                        return;
                    }
                    Location currentLocation = start.clone().add((double)this.x, (double)(this.y - 1), (double)this.z);
                    Block b = currentLocation.getBlock();
                    if (!turn) {
                        if (b.getType() == Material.OCHRE_FROGLIGHT) {
                            b.setType(Material.BLACK_WOOL);
                        } else if (b.getType() == Material.GLOWSTONE) {
                            b.setType(Material.BLACK_TERRACOTTA);
                        }
                    } else if (b.getType() == Material.BLACK_WOOL) {
                        b.setType(Material.OCHRE_FROGLIGHT);
                    } else if (b.getType() == Material.BLACK_TERRACOTTA) {
                        b.setType(Material.GLOWSTONE);
                    }
                    ++this.x;
                    if (this.x > max) {
                        this.x = 0;
                        ++this.z;
                    }
                    if (this.z <= max) continue;
                    this.z = 0;
                    ++this.y;
                }
            }
        }.runTaskTimer((Plugin)SUHCore.instance, 0L, 1L);
    }

    private void debug(CommandSender commandSender, String[] strings) {
        commandSender.sendMessage(this.center.toString());
    }

    private void reset(String[] strings) {
        if (strings.length >= 2) {
            boolean turn = strings[1].equalsIgnoreCase("true");
            this.luz(turn);
        }
        FLogger.info("reset() iniciado");
        Location loc = this.center.clone();
        int radius = (int)this.jsonMinigame.getJSONObject("center").getDouble("radio");
        final ArrayList toRemove = new ArrayList();
        loc.getNearbyEntities((double)(radius + 1), 1.0, (double)(radius + 1)).forEach(e -> {
            if (e instanceof BlockDisplay) {
                BlockDisplay bd = (BlockDisplay)e;
                toRemove.add(bd);
            }
        });
        final Location blockMain = new Location(loc.getWorld(), (double)(loc.getBlockX() - radius), (double)loc.getBlockY(), (double)(loc.getBlockZ() - radius), 0.0f, 0.0f);
        final int max = radius * 2;
        int ENTITIES_PER_TICK = 500;
        int BLOCKS_PER_TICK = 500;
        new BukkitRunnable(){
            int phase = 0;
            int entIdx = 0;
            int x = 0;
            int z = 0;

            public void run() {
                if (this.phase == 0) {
                    for (int processed = 0; this.entIdx < toRemove.size() && processed < 500; ++processed) {
                        BlockDisplay bd;
                        if ((bd = (BlockDisplay)toRemove.get(this.entIdx++)).isDead()) continue;
                        bd.remove();
                    }
                    if (this.entIdx >= toRemove.size()) {
                        this.phase = 1;
                    }
                    return;
                }
                for (int processed = 0; processed < 500; ++processed) {
                    if (this.z > max) {
                        this.cancel();
                        FLogger.info("reset() completado");
                        return;
                    }
                    Location currentLocation = blockMain.clone().add((double)this.x, 0.0, (double)this.z);
                    Location key = Mingle.this.redondearCords(currentLocation);
                    if (Mingle.this.hashMapLocBlock.containsKey(key)) {
                        Block currentBlock = currentLocation.getBlock();
                        currentBlock.setBlockData(Mingle.this.locBlockgetHashMap(key));
                        Mingle.this.locBlockdelHashMap(key);
                    }
                    ++this.x;
                    if (this.x <= max) continue;
                    this.x = 0;
                    ++this.z;
                }
            }
        }.runTaskTimer((Plugin)SUHCore.instance, 0L, 1L);
    }

    private void setMingleCenter(Player player, String[] strings) {
        if (strings.length >= 2) {
            Integer radiuo = Integer.parseInt(strings[1]);
            JSONObject loc = this.jsonMinigame.getJSONObject("center");
            String mundo = player.getWorld().getName();
            int x = player.getLocation().getBlockX();
            int y = player.getLocation().getBlockY();
            int z = player.getLocation().getBlockZ();
            loc.put("world", mundo);
            loc.put("x", x);
            loc.put("y", y);
            loc.put("z", z);
            loc.put("radio", radiuo);
            this.jsonMinigame.put("center", loc);
            this.center = this.redondearCords(player.getLocation());
            player.sendMessage("hecho");
        }
    }

    private void transformar() {
        int radius = (int)this.jsonMinigame.getJSONObject("center").getDouble("radio");
        this.armStand = this.center.getWorld().spawn(this.center, ArmorStand.class);
        Location blockMain = new Location(this.center.getWorld(), (double)(this.center.getBlockX() - radius), (double)this.center.getBlockY(), (double)(this.center.getBlockZ() - radius), 0.0f, 0.0f);
        final ArrayList<Location> blocks = new ArrayList<Location>();
        for (int x = 0; x <= radius * 2; ++x) {
            for (int z = 0; z <= radius * 2; ++z) {
                Location currentLocation = blockMain.clone().add((double)x + 0.5, 0.0, (double)z + 0.5);
                blocks.add(currentLocation);
            }
        }
        new BukkitRunnable(){
            int index = 0;

            public void run() {
                for (int processed = 0; this.index < blocks.size() && processed < 200; ++processed) {
                    Location currentLocation = (Location)blocks.get(this.index);
                    Block currentBlock = currentLocation.getBlock();
                    if (currentBlock.getType() != Material.AIR) {
                        Mingle.this.locBlockaddHashMap(Mingle.this.redondearCords(currentLocation), currentBlock.getBlockData());
                        BlockDisplay display = (BlockDisplay)currentLocation.getWorld().spawnEntity(currentLocation, EntityType.BLOCK_DISPLAY);
                        Transformation transformation = display.getTransformation();
                        transformation.getTranslation().set(-0.5, 0.0, -0.5);
                        display.setTransformation(transformation);
                        display.setBlock(currentBlock.getBlockData());
                        Mingle.this.displays.add(display);
                        currentBlock.setType(Material.BARRIER);
                    }
                    ++this.index;
                }
                if (this.index >= blocks.size()) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)SUHCore.instance, 0L, 1L);
    }

    private Location redondearCords(Location loc) {
        return new Location(loc.getWorld(), (double)loc.getBlockX(), loc.getY(), (double)loc.getBlockZ(), 0.0f, 0.0f);
    }

    private void rotarEstructura(int vueltas, int segundos, String[] strings) {
        if (strings.length >= 4 && strings[3].equalsIgnoreCase("true")) {
            this.transformar();
        }
        final double totalRotacion = Math.PI * (double)vueltas / 2.0;
        final double incremento = totalRotacion / (double)(20 * segundos);
        double gradostotales = 90 * vueltas;
        final double gradosPerTick = gradostotales / (double)(segundos * 20);
        for (BlockDisplay display : this.displays) {
            this.addHashMap(display);
        }
        new BukkitRunnable(){
            double rotacionActual = 0.0;
            double gradoActual = 0.0;
            final double cos = Math.cos(incremento);
            final double sin = Math.sin(incremento);

            public void run() {
                if (this.rotacionActual >= totalRotacion) {
                    for (BlockDisplay display : Mingle.this.displays) {
                        display.teleport(Mingle.this.getHashMap(display));
                        Mingle.this.delHashMap(display);
                    }
                    Mingle.this.luz(false);
                    this.cancel();
                    return;
                }
                this.gradoActual += gradosPerTick;
                for (BlockDisplay display : Mingle.this.displays) {
                    Vector offset = display.getLocation().toVector().subtract(Mingle.this.center.toVector().add(new Vector(0.5, 0.0, 0.5)));
                    double x = offset.getX() * this.cos - offset.getZ() * this.sin;
                    double z = offset.getX() * this.sin + offset.getZ() * this.cos;
                    Vector rotatedOffset = new Vector(x, offset.getY(), z);
                    Location newLocation = Mingle.this.center.clone().add(rotatedOffset).add(new Vector(0.5, 0.0, 0.5));
                    newLocation.setYaw((float)this.gradoActual);
                    display.teleport(newLocation);
                }
                Mingle.this.center.getNearbyPlayers(Mingle.this.jsonMinigame.getJSONObject("center").getDouble("radio"), 3.0).forEach(p -> {
                    Vector offset = p.getLocation().toVector().subtract(Mingle.this.center.toVector().add(new Vector(0.5, 0.0, 0.5)));
                    double x = offset.getX() * this.cos - offset.getZ() * this.sin;
                    double z = offset.getX() * this.sin + offset.getZ() * this.cos;
                    Vector rotatedOffset = new Vector(x, offset.getY(), z);
                    Location newLocation = Mingle.this.center.clone().add(rotatedOffset).add(new Vector(0.5, 0.0, 0.5));
                    newLocation.setYaw((float)this.gradoActual);
                    newLocation.setPitch(p.getPitch());
                    p.teleport(newLocation);
                    Mingle.this.teleportAndLookAt((Entity)p, Mingle.this.armStand);
                });
                this.rotacionActual += incremento;
            }
        }.runTaskTimer((Plugin)SUHCore.instance, 0L, 1L);
    }

    private void teleportAndLookAt(Entity player, Entity target) {
        Location playerLoc = player.getLocation();
        Location targetLoc = target.getLocation();
        double dx = targetLoc.getX() - playerLoc.getX();
        double dz = targetLoc.getZ() - playerLoc.getZ();
        float yaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
        Location teleportLocation = playerLoc.clone();
        teleportLocation.setYaw(yaw - 180.0f);
        teleportLocation.setPitch(0.0f);
        player.teleport(teleportLocation);
    }

    @Override
    protected void saveMinigameData() {
        JSONArray doors = new JSONArray();
        for (Door d : this.doors) {
            JSONObject door = new JSONObject();
            door.put("axis", d.axis.toString());
            door.put("hitbox", d.hitbox.toString());
            JSONObject luz = new JSONObject();
            luz.put("x", d.luz.x);
            luz.put("y", d.luz.y);
            luz.put("z", d.luz.z);
            luz.put("light", d.luz.light);
            JSONObject collision = new JSONObject();
            collision.put("a", d.collision.stand.toString());
            collision.put("s", d.collision.shulker.toString());
            door.put("collision", collision);
            door.put("luz", luz);
            door.put("yaw", d.yaw);
            door.put("locked", d.locked);
            door.put("opened", d.opened);
            doors.put(door);
        }
        this.jsonMinigame.put("doors", doors);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "commandSender";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "strings";
                break;
            }
        }
        objectArray[1] = "me/fixfis/sUHCore/minijuegos/Mingle";
        objectArray[2] = "comando";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record Collision(UUID stand, UUID shulker) {
        @Override
        @NotNull
        public String toString() {
            String string = "Collision{stand=" + String.valueOf(this.stand) + ", shulker=" + String.valueOf(this.shulker) + "}";
            if (string == null) {
                Collision.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "me/fixfis/sUHCore/minijuegos/Mingle$Collision", "toString"));
        }
    }

    private static class Luz {
        private final int x;
        private final int y;
        private final int z;
        private boolean light;

        public Luz(int x, int y, int z, boolean light) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.light = light;
        }

        public void convertBlock() {
            world.getBlockAt(this.x, this.y, this.z).setType(this.light ? Material.OCHRE_FROGLIGHT : Material.BLACK_TERRACOTTA);
        }

        public void setLight(boolean light) {
            this.light = light;
        }

        public String toString() {
            return "Luz{x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", light=" + this.light + "}";
        }
    }

    private static class Door {
        public final UUID axis;
        public final UUID hitbox;
        public final Collision collision;
        public final Luz luz;
        public final Integer yaw;
        private boolean locked;
        private boolean opened;

        public Door(UUID axis, UUID hitbox, Luz luz, Collision collision, Integer yaw, boolean locked, boolean opened) {
            this.axis = axis;
            this.hitbox = hitbox;
            this.luz = luz;
            this.collision = collision;
            this.yaw = yaw;
            this.locked = locked;
            this.opened = opened;
        }

        public void setOpened(boolean opened) {
            this.opened = opened;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }

        public String toString() {
            return "Door{axis=" + String.valueOf(this.axis) + ", hitbox=" + String.valueOf(this.hitbox) + ", collision=" + String.valueOf(this.collision) + ", luz=" + String.valueOf(this.luz) + ", yaw=" + this.yaw + ", locked=" + this.locked + ", opened=" + this.opened + "}";
        }
    }
}

