/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.mobs.modMobs.mobs;

import java.util.Objects;
import me.fixfis.sUHCore.mobs.modMobs.EntityAttributes;
import me.fixfis.sUHCore.mobs.modMobs.MobAttributes;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FLivingEntities;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public abstract class FMonster<T extends Mob>
extends FLivingEntities<T>
implements Listener {
    private MobAttributes mobAttributes;

    public FMonster(Class<T> claseEntidad, String keyName, EntityAttributes attributes) {
        super(claseEntidad, keyName);
        if (attributes != null) {
            this.mobAttributes = new MobAttributes(keyName, attributes);
        }
    }

    @EventHandler
    public final void onTarget(EntityTargetLivingEntityEvent event) {
        LivingEntity livingEntity;
        if (this.isThisEntity(event.getEntity()) && (livingEntity = event.getTarget()) instanceof Player) {
            Player player = (Player)livingEntity;
            this.onThisEntityTargetPlayer((Mob)this.claseEntidad.cast(event.getEntity()), player, event);
        }
    }

    public void onThisEntityTargetPlayer(T entity, Player player, EntityTargetLivingEntityEvent event) {
    }

    @Override
    public final void onDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isThisEntity(event.getDamager())) {
                this.onPlayerDamagedByThisEntity((Mob)this.claseEntidad.cast(event.getDamager()), player, event);
            } else {
                Entity entity2;
                Arrow arrow;
                Entity entity3 = event.getDamager();
                if (entity3 instanceof Arrow && (entity3 = (arrow = (Arrow)entity3).getShooter()) instanceof Entity && this.isThisEntity(entity2 = entity3)) {
                    this.onPlayerDamagedByThisEntityByArrow(arrow, (Mob)this.claseEntidad.cast(entity2), player, event);
                }
            }
        } else if (this.isThisEntity(event.getEntity())) {
            Entity entity4 = event.getDamager();
            if (entity4 instanceof Player) {
                Player player = (Player)entity4;
                this.onThisEntityDamagedByPlayer((Mob)this.claseEntidad.cast(event.getEntity()), player, event);
            } else {
                Arrow arrow;
                entity4 = event.getDamager();
                if (entity4 instanceof Arrow && (entity4 = (arrow = (Arrow)entity4).getShooter()) instanceof Player) {
                    Player player = (Player)entity4;
                    this.onThisEntityDamagedByPlayerByArrow(arrow, (Mob)this.claseEntidad.cast(event.getEntity()), player, event);
                }
            }
        }
    }

    public final void setAttributes(T mob) {
        if (this.mobAttributes == null) {
            return;
        }
        Objects.requireNonNull(mob.getAttribute(Attribute.MAX_HEALTH)).setBaseValue(this.mobAttributes.getHealth().doubleValue());
        Objects.requireNonNull(mob.getAttribute(Attribute.ATTACK_KNOCKBACK)).setBaseValue(this.mobAttributes.getAttack_knockback().doubleValue());
        Objects.requireNonNull(mob.getAttribute(Attribute.KNOCKBACK_RESISTANCE)).setBaseValue(this.mobAttributes.getKnockback_resistance().doubleValue());
        Objects.requireNonNull(mob.getAttribute(Attribute.ARMOR)).setBaseValue(this.mobAttributes.getArmor().doubleValue());
        Objects.requireNonNull(mob.getAttribute(Attribute.SCALE)).setBaseValue(this.mobAttributes.getScale().doubleValue());
        Objects.requireNonNull(mob.getAttribute(Attribute.ATTACK_DAMAGE)).setBaseValue(this.mobAttributes.getAttack_damage().doubleValue());
        Objects.requireNonNull(mob.getAttribute(Attribute.FOLLOW_RANGE)).setBaseValue(this.mobAttributes.getFollow_range().doubleValue());
        Objects.requireNonNull(mob.getAttribute(Attribute.MOVEMENT_SPEED)).setBaseValue(this.mobAttributes.getSpeed().doubleValue());
        Objects.requireNonNull(mob.getAttribute(Attribute.JUMP_STRENGTH)).setBaseValue(this.mobAttributes.getJump().doubleValue());
        if (mob instanceof Creeper) {
            Creeper creeper = (Creeper)mob;
            creeper.setPowered(this.mobAttributes.isPowered());
            creeper.setMaxFuseTicks(this.mobAttributes.getTicks_to_explode());
            creeper.setExplosionRadius(this.mobAttributes.getExplosion_radius().intValue());
        }
    }

    protected void onPlayerDamagedByThisEntity(T entity, Player player, EntityDamageByEntityEvent event) {
    }

    protected void onPlayerDamagedByThisEntityByArrow(Arrow arrow, T entity, Player player, EntityDamageByEntityEvent event) {
    }

    @Override
    protected final void initViewPeaceful(T entity) {
        this.setAttributes(entity);
        if (entity instanceof Ageable) {
            Ageable ageable = (Ageable)entity;
            ageable.setAdult();
        }
        this.initViewMonster(entity);
    }

    public abstract void initViewMonster(T var1);

    public final void saveData() {
        if (this.mobAttributes != null) {
            this.mobAttributes.save();
        }
    }

    public final void loadData() {
        if (this.mobAttributes != null) {
            this.mobAttributes.load();
        }
    }
}

