/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.muertes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.animaciones.SUHAnim;
import me.fixfis.sUHCore.config.SUHGenericConfig;
import me.fixfis.sUHCore.events.SUHEvents;
import me.fixfis.sUHCore.items.SUHItems;
import me.fixfis.sUHCore.muertes.savedInvs.InvContainer;
import me.fixfis.sUHCore.specialEvents.EncadenadoMap;
import me.fixfis.sUHCore.tps.SUHTps;
import me.fixfis.sUHCore.utils.Texto;
import me.fixfis.sUHCore.utils.logger.FLogger;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.JSONArray;

public class Muertos {
    public static List<UUID> muertos = new ArrayList<UUID>();
    public static Set<InvContainer> invs = new HashSet<InvContainer>();

    public static void load() {
        if (SUHCore.FILEmuertes.has("muertos")) {
            JSONArray array = SUHCore.FILEmuertes.getJSONArray("muertos");
            array.forEach(uuid -> muertos.add(UUID.fromString(uuid.toString())));
        } else {
            SUHCore.FILEmuertes.put("muertos", new JSONArray());
        }
    }

    public static void save() {
        JSONArray array = new JSONArray();
        muertos.forEach(uuid -> array.put(uuid.toString()));
        SUHCore.FILEmuertes.put("muertos", array);
    }

    public static void addMuerto(UUID uuid) {
        if (!Muertos.isMuerto(uuid)) {
            muertos.add(uuid);
        }
    }

    public static void removeMuerto(UUID uuid) {
        muertos.remove(uuid);
    }

    public static boolean isMuerto(UUID uuid) {
        return muertos.contains(uuid);
    }

    public static void playerDead(final Player player, String deadMsg) {
        Muertos.addMuerto(player.getUniqueId());
        Bukkit.getOnlinePlayers().forEach(p -> {
            SUHAnim.KILLCARD.getAnim().CLIENTsendAnimation((Player)p, false);
            p.sendActionBar((Component)Component.text((String)Texto.aColor("&c" + player.getName() + " ha muerto")));
            p.sendMessage(Texto.aColor("&c \u2620 " + player.getName() + " \u2620"));
            p.sendMessage(Texto.aColor("&c " + deadMsg));
            p.sendMessage(Texto.aColor("&c x: " + player.getLocation().getBlockX() + " y: " + player.getLocation().getBlockY() + " z: " + player.getLocation().getBlockZ()));
        });
        EncadenadoMap.removeUser(player);
        player.setGameMode(GameMode.SPECTATOR);
        invs.add(new InvContainer(player, player.getInventory().getContents(), player.calculateTotalExperiencePoints()));
        for (ItemStack content : player.getInventory().getContents()) {
            if (content == null || content.getType() == Material.BARRIER) continue;
            player.getWorld().dropItemNaturally(player.getLocation(), content);
        }
        player.getWorld().dropItemNaturally(player.getLocation(), SUHItems.UTILS_SOUL.getItemStack());
        player.getInventory().clear();
        new BukkitRunnable(){

            public void run() {
                if (SUHEvents.LIMBO.isEnabled() && SUHCore.random.nextFloat() < (float)((Integer)SUHGenericConfig.PROBABILIDAD_LIMBO.getValue()).intValue() / 100.0f) {
                    player.sendMessage(Texto.aColor("&cParece que el destino te dio otra oportunidad... Busca la salida de este sitio para poder revivir"));
                    player.teleport(SUHTps.MAP_TPS.get("limbo").getLocation());
                    player.setGameMode(GameMode.SURVIVAL);
                    FLogger.debugging("USUARIO ENTR\u00d3 AL LIMBO");
                    return;
                }
                player.kick((Component)Component.text((String)Texto.aColor("&c Has muerto GG!")), PlayerKickEvent.Cause.WHITELIST);
            }
        }.runTaskLater((Plugin)SUHCore.instance, 100L);
    }
}

