/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Objects;
import me.fixfis.Entities.Auth;
import me.fixfis.Entities.ServerStuff;
import me.fixfis.stuff.FPluginManagerCommands;
import me.fixfis.stuff.FPluginManagerEvents;
import me.fixfis.stuff.LocalLogger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class InitServer {
    public static String TOKEN = "b3t7d3pBNjZ6bHl9bHk1bXB/bXB6NXZ1c3B1bDZtd3N8bnB1Ng==";
    public static int ID = 17;
    private final int idPlugin;
    private final String ipServer;
    private final boolean local;
    private final JavaPlugin plugin;
    private final String mainCommand;
    private final Auth auth;
    private final ServerStuff serverStuff;
    private boolean estadoDeLicencia;

    public InitServer(int idPlugin, JavaPlugin plugin, String mainCommand, boolean local) {
        this.local = local;
        this.idPlugin = idPlugin;
        this.ipServer = this.getPublicIp();
        this.plugin = plugin;
        this.mainCommand = mainCommand;
        this.auth = new Auth();
        this.serverStuff = new ServerStuff();
        this.serverStuff.addPowerOn(this.ipServer, idPlugin);
        this.validarDatos();
        if (plugin.isEnabled()) {
            new BukkitRunnable(){

                public void run() {
                    InitServer.this.validarDatos();
                }
            }.runTaskTimer((Plugin)plugin, 6000L, 6000L);
        }
    }

    public void validarDatos() {
        int response = this.auth.getAuth(this.ipServer, this.idPlugin).getInt("v");
        switch (response) {
            case 0: {
                LocalLogger.loggerAd(this.plugin.getName() + ">> El Plugin est\u00e1 en cole de aprobaci\u00f3n, \u00bfEsta aprobado?, reinicie el servidor.");
                this.estadoDeLicencia = false;
                this.plugin.setEnabled(false);
                break;
            }
            case 1: {
                LocalLogger.loggerAd(this.plugin.getName() + ">> El Plugin esta activado.");
                this.estadoDeLicencia = true;
                this.plugin.setEnabled(true);
                break;
            }
            case 10: {
                LocalLogger.loggerAd(this.plugin.getName() + ">> Falta enviar Autentificacion de uso.");
                Objects.requireNonNull(this.plugin.getCommand(this.mainCommand)).setExecutor((CommandExecutor)new FPluginManagerCommands(this));
                this.plugin.getServer().getPluginManager().registerEvents((Listener)new FPluginManagerEvents(this), (Plugin)this.plugin);
                this.plugin.setEnabled(false);
                this.estadoDeLicencia = false;
                break;
            }
            default: {
                this.estadoDeLicencia = false;
            }
        }
    }

    private String getPublicIp() {
        if (this.local) {
            try {
                InetAddress ip = InetAddress.getLocalHost();
                return ip.getHostAddress();
            }
            catch (UnknownHostException e) {
                return "NO_SE_PUDO_OBTENER_IP";
            }
        }
        try {
            URL url = new URL("https://api.ipify.org");
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            return in.readLine() + ":" + Bukkit.getServer().getPort();
        }
        catch (Exception e) {
            return "NO_SE_PUDO_OBTENER_IP";
        }
    }

    public String toString() {
        return "InitServer{idPlugin=" + this.idPlugin + ", ipServer='" + this.ipServer + "', plugin=" + String.valueOf(this.plugin) + ", mainCommand='" + this.mainCommand + "', auth=" + String.valueOf(this.auth) + ", serverStuff=" + String.valueOf(this.serverStuff) + ", estadoDeLicencia=" + this.estadoDeLicencia + "}";
    }

    public Auth getAuth() {
        return this.auth;
    }

    public boolean getEstadoDeLicencia() {
        return this.estadoDeLicencia;
    }

    public ServerStuff getServerStuff() {
        return this.serverStuff;
    }

    public String getIpServer() {
        return this.ipServer;
    }

    public int getIdPlugin() {
        return this.idPlugin;
    }
}

